% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc_grid_to_dt.R
\name{nc_grid_to_dt}
\alias{nc_grid_to_dt}
\title{Convert a netcdf array to long format as data.table}
\usage{
nc_grid_to_dt(
  filename,
  variable,
  icell_raster_pkg = TRUE,
  add_xy = FALSE,
  interpolate_to_standard_calendar = FALSE,
  date_range,
  verbose = FALSE
)
}
\arguments{
\item{filename}{Complete path to .nc file.}

\item{variable}{Name of the variable to extract from \code{filename}
(character).}

\item{icell_raster_pkg}{Boolean, if \code{TRUE}, cell indices will be ordered
as if you were extracting the data with the raster package.}

\item{add_xy}{Boolean, if \code{TRUE}, adds columns with x and y coordinates.}

\item{interpolate_to_standard_calendar}{Boolean, if \code{TRUE} will use
\code{\link{map_non_standard_calendar}} to interpolate values to a standard
calendar.}

\item{date_range}{(optional) two-element vector of class Date (min, max),
which will be used to extract only parts of the netcdf file}

\item{verbose}{Boolean, if \code{TRUE}, prints more information.}
}
\value{
A \code{\link[data.table]{data.table}} with columns: \itemize{\item
  icell: Cell index \item date: Date of class \code{\link{Date}}, if file has
  a standard calendar. Date as character, if it has a non-standard calendar
  (360, noleap) and if \code{interpolate_to_standard_calendar} is set to
  \code{FALSE}. If \code{interpolate_to_standard_calendar} is \code{TRUE},
  it's always of class \code{\link{Date}}. \item variable: Values, column is
  renamed to input \code{variable} \item (optional) x,y: Coordinates of
  netcdf dimensions, will be renamed to dimension names found in array named
  after input \code{variable}}
}
\description{
Extracts a variable from netcdf, and returns a
\code{\link[data.table]{data.table}} with cell index, date, values, and
optionally: coordinates.
}
\details{
Coordinates are usually not put in the result, because it saves space. It is
recommended to merge them after the final operations. The unique cell index
is more efficient. However, if you plan to merge to data extracted with the
raster package (assuming the same grid), then cell indices might differ. Set
\code{icell_raster_pkg} to \code{TRUE}, to have the same cell indices. Note
that raster and ncdf4 have different concepts of coordinates (cell corner vs.
cell center), so merging based on coordinates can produce arbitrary results
(besides rounding issues).
}
\section{Warning}{
 Netcdf files can be huge, so loading everything in memory
  can rapidly crash your R session. Think first about subsetting or
  aggregating (e.g. using CDO:
  \url{https://code.mpimet.mpg.de/projects/cdo/}).
}

\examples{
# example data from EURO-CORDEX (cropped for size)
fn1 <- system.file("extdata", "test1.nc", package = "eurocordexr")
dat <- nc_grid_to_dt(
  filename = fn1,
  variable = "tasmin"
)
str(dat)
}
\seealso{
The raster and terra packages can also open netcdf files and create
  data.frames with \code{raster::as.data.frame}
  or \code{terra::as.data.frame}. But, it does
  not handle non-standard calendars, and returns a data.frame, which is
  slower than data.table.
}
