% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{etrd_order_history}
\alias{etrd_order_history}
\title{ETrade order-related information}
\usage{
etrd_order_history(
  account,
  count = 100,
  status = NULL,
  fromDate = Sys.Date() - 30,
  toDate = Sys.Date(),
  symbol = NULL,
  securityType = NULL,
  transactionType = NULL,
  marketSession = NULL,
  output = c("df", "list"),
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{account}{The account ID key, not the account ID associated with the
specific account. Use \code{\link{etrd_account_list}} to identify the
proper account id key.}

\item{count}{Number of orders to return with a max of 100}

\item{status}{a valid status: OPEN, EXECUTED, CANCELLED, INDIVIDUAL_FILLS,
CANCEL_REQUESTED, EXPIRED, REJECTED, PARTIAL, DO_NOT_EXERCISE,
DONE_TRADE_EXECUTED}

\item{fromDate}{a date object for the start of the filter}

\item{toDate}{a data object for the end of the filter}

\item{symbol}{a specific symbol to filter for}

\item{securityType}{a valid security type: EQ, OPTN, MF, MMF}

\item{transactionType}{a valid transaction type: ATNM, BUY, SELL, SELL_SHORT,
BUY_TO_COVER, MF_EXCHANGE}

\item{marketSession}{REGULAR, EXTENDED}

\item{output}{Indicate whether the output should be in the form of a data
frame ('df') or list ('list'). Data frame is returned by default.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a list or df of orders
}
\description{
Provides the order details for a selected brokerage account based on the
search criteria provided.
}
\examples{
\dontrun{

# Search for mutual fund buys over the last month
account_id = etrd_account_list()$accountIdKey[1]
etrd_order_history(account_id, transactionType = 'BUY', securityType = 'mf',
                status = 'EXECUTED', fromDate = Sys.Date()-30, toDate = Sys.Date())

}
}
