% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market.R
\name{etrd_market_quote}
\alias{etrd_market_quote}
\title{ETrade Quotes}
\usage{
etrd_market_quote(
  symbols = c("AAPL", "MSFT", "SPY"),
  detailFlag = "ALL",
  output = c("df", "list"),
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{symbols}{One or more symbols for equities or options, up to a maximum
of 50 Symbols for equities are simple, for example, GOOG. Symbols for
options are more complex, consisting of six elements separated by colons,
in this format: underlier:year:month:day:optionType:strikePrice.}

\item{detailFlag}{Determines the market fields returned from a quote request.
The default is ALL. Options: ALL, FUNDAMENTAL, INTRADAY, OPTIONS, WEEK_52,
MF_DETAIL}

\item{output}{Indicate whether the output should be in the form of a data
frame ('df') or list ('list'). Data frame is returned by default.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a list or data frame of quote data
}
\description{
Retrieves the quote information for one or more specified symbols. To receive
access to real-time market data, you would need to sign the market data
agreement.Otherwise, you will receive delayed market data.
}
\examples{
\dontrun{

# Get quotes for 3 symbols
etrd_market_quote(c('AAPL','MSFT','SPY'))

}
}
