% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radial_plot.R
\name{Radial_plot}
\alias{Radial_plot}
\title{Radial bar plot of use reports (UR) per species}
\usage{
Radial_plot(data, analysis)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.
The rest of the columns are the identified ethnobotany use categories. The data should be populated with counts of uses per person (should be 0 or 1 values).}

\item{analysis}{is one of the quantitative ethnobotany functions from ethnobotanyR, i.e. ethnobotanyR::FCs.}
}
\description{
Creates a radial bar plot of use reports (UR) per species based on the `UR function`.
}
\examples{

#Use built-in ethnobotany data example and Frequency of Citation function FCs()
Radial_plot(ethnobotanydata, analysis = FCs)

#Generate random dataset of three informants uses for four species
eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant<-sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name<-sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)
Radial_plot(data = eb_data, analysis = FCs)

}
\keyword{cultural}
\keyword{ethnobotany,}
\keyword{report}
\keyword{use}
\keyword{value,}
