% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatr_lh_robust.R
\name{lh_robust}
\alias{lh_robust}
\title{Linear Hypothesis for Ordinary Least Squares with Robust Standard Errors}
\usage{
lh_robust(..., data, linear_hypothesis)
}
\arguments{
\item{...}{Other arguments to be passed to  \code{\link{lm_robust}}}

\item{data}{A \code{data.frame}}

\item{linear_hypothesis}{A character string or a matrix specifying combination, to be passed to the hypothesis.matrix argument of car::linearHypothesis
See \code{\link[car]{linearHypothesis}} for more details.}
}
\value{
An object of class \code{"lh_robust"} containing the two following components:

\item{lm_robust}{an object as returned by \code{lm_robust}.}
\item{lh}{A data frame with most of its columns pulled from \code{linearHypothesis}' output.}

The only analyis directly performed by \code{lh_robust} is a \code{t-test} for the null hypothesis of no effects of the linear combination of coefficients as specified by the user.
All other output components are either extract from \code{linearHypothesis} or \code{lm_robust}.

The original output returned by \code{linearHypothesis} is added as an attribute.
}
\description{
This function fits a linear model with robust standard errors and performs linear hypothesis test.
}
\details{
This function is a wrapper for \code{\link{lm_robust}} and for
\code{\link[car]{linearHypothesis}}. It first runs \code{lm_robust} and
next passes \code{"lm_robust"} object as an argument to \code{linearHypothesis}.
}
\examples{

library(fabricatr)
dat <- fabricate(
  N = 40,
  y = rpois(N, lambda = 4),
  x = rnorm(N),
  z = rbinom(N, 1, prob = 0.4),
  clusterID = sample(1:4, 40, replace = TRUE)
)

# Default variance estimator is HC2 robust standard errors
lhro <- lh_robust(y ~ x + z, data = dat, linear_hypothesis = "z + 2x = 0")

# The linear hypothesis argument can be specified equivalently as:
lh_robust(y ~ x + z, data = dat, linear_hypothesis = "z = 2x")
lh_robust(y ~ x + z, data = dat, linear_hypothesis = c("z = 1", "x = 2"))
lh_robust(y ~ x + z, data = dat, linear_hypothesis = "2*x +1*z")
lh_robust(y ~ x + z, data = dat, linear_hypothesis = "z + 2x = 0")

# Also recovers other sorts of standard erorrs just as specified in \\code{\\link{lm_robust}}
lh_robust(y ~ x + z, data = dat, linear_hypothesis = "z + 2x = 0", se_type = "classical")
lh_robust(y ~ x + z, data = dat, linear_hypothesis = "z + 2x = 0", se_type =  "HC1")

#  Can tidy() main output and subcomponents in to a data.frame
lhro <- lh_robust(y ~ x + z, data = dat, linear_hypothesis = "z + 2x = 0")
tidy(lhro )
tidy(lhro$lm_robust)
tidy(lhro$lh)

# Can use summary() to get more statistics on the main output and subcomponents.
summary(lhro)
summary(lhro$lm_robust)
summary(lhro$lh)

}
