% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_lm_robust_fit.R
\name{lm_robust_fit}
\alias{lm_robust_fit}
\title{Internal method that creates linear fits}
\usage{
lm_robust_fit(y, X, yoriginal = NULL, Xoriginal = NULL, weights, cluster,
  fixed_effects = NULL, ci = TRUE, se_type, has_int, alpha = 0.05,
  return_vcov = TRUE, return_fit = TRUE, try_cholesky = FALSE,
  iv_stage = list(0))
}
\arguments{
\item{y}{numeric outcome vector}

\item{X}{numeric design matrix}

\item{yoriginal}{numeric outcome vector, unprojected if there are fixed effects}

\item{Xoriginal}{numeric design matrix, unprojected if there are fixed effects}

\item{weights}{numeric weights vector}

\item{cluster}{numeric cluster vector}

\item{fixed_effects}{character matrix of fixed effect groups}

\item{ci}{boolean that when T returns confidence intervals and p-values}

\item{se_type}{character denoting which kind of SEs to return}

\item{has_int}{logical, whether the model has an intercept, used for \eqn{R^2}}

\item{alpha}{numeric denoting the test size for confidence intervals}

\item{return_vcov}{logical, whether to return the vcov matrix for later usage}

\item{return_fit}{logical, whether to return fitted values}

\item{try_cholesky}{logical, whether to try using a cholesky decomposition to solve LS instead of a QR decomposition}

\item{iv_stage}{list of length two, the first element denotes the stage of 2SLS IV estimation, where 0 is used for OLS. The second element is only used for the second stage of 2SLS and has the first stage design matrix. For OLS, the default, \code{list(0)}, for the first stage of 2SLS \code{list(1)}, for second stage of 2SLS \code{list(2, first_stage_design_mat)}.}
}
\description{
Internal method that creates linear fits
}
