% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contraste_independencia.R
\name{contraste_independencia}
\alias{contraste_independencia}
\title{Contraste de Independencia.}
\usage{
contraste_independencia(x, introducir = FALSE, alfa = 0.05, grafico = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser una matriz o un dataframe. Debe contener sólo 2 columnas.}

\item{introducir}{Valor lógico. Si \code{introducir = FALSE} (por defecto), el usuario debe indicar el conjunto de datos que desea analizar usando los argumentos \code{x} y/o \code{variable}. Si \code{introducir = TRUE}, se le solicitará al ususario que introduzca la información relevante sobre el número de categorías de cada una de las variables, el nombre de cada categoría de la variable fila y de la variable columna. A continuación se abrirá una ventana con un editor de datos y deberá introducir los valores de las frecuencias observadas de la tabla de contingencia.}

\item{alfa}{Es un valor numérico entre 0 y 1. Indica el nivel de significación. Por defecto, \code{alfa = 0.05} (5 por ciento)}

\item{grafico}{Es un valor lógico. Por defecto \code{grafico = FALSE}. Si se quiere obtener una representación gráfica del contraste realizado, cambiar el argumento a \code{grafico = TRUE}.}
}
\value{
La función devuelve un objeto de la clase \code{list}. La lista contendrá información sobre: la hipótesis nula contrastada, el estadístico de prueba y el p-valor. Si \code{grafico=TRUE} se incluirá una representación gráfica de la región de aceptación-rechazo con el valor crítico.
}
\description{
Contrasta la hipótesis de independencia entre las categorías de dos variables categóricas o criterios de clasificación en los que se encuentra clasificada la muestra proveniente de dicha población bidimensional.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.
}
\details{
(1) El estadístico del contraste de independencia es:

\deqn{\chi ^{2} = \sum_{i=1}^{I} \sum_{j=1}^{J}
\frac{(O_{ij} - E_{ij})^{2}}{E_{ij}} =
\sum_{i=1}^{I} \sum_{j=1}^{J}
\frac{(O_{ij} - \frac{O_{i.} \times O_{.j}}{n})^{2}}{\frac{O_{i.} \times O_{.j}}{n}}}

donde \eqn{O_{ij}} son las frecuencias conjuntas observadas, \eqn{E_{ij}} son las frecuencias teóricas o esperadas,
\eqn{O_{i.}} y \eqn{O_{.j}} son las frecuencias marginales de cada variable, y \eqn{n} es el tamaño de la muestra.

\deqn{\chi_{(I-1)(J-1)}^{2}}

donde \eqn{I} y \eqn{J} son el número de categorías de la variable fila y de la variable columna, respectivamente.

Además, se exige que el tamaño de la muestra sea grande y que todas las frecuencias teóricas no estén por debajo de 5.
Si alguna no lo cumple, es necesario reagrupar las categorías contiguas hasta conseguir superar esa cota.

(2) Si el número de grados de libertad es 1, al estadístico del contraste se le aplica la siguiente corrección de Yates:

\deqn{\chi ^{2} = \sum_{i=1}^{k}
\frac{(\left| O_{i} - E_{i} \right| - 0.5)^{2}}{E_{i}}}
}
\references{
Casas José M. (1997) Inferencia estadística. Editorial: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\seealso{
\code{\link{contraste_homogeneidad}},\code{\link{contraste_bondad_cat}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
