% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_dgmsim.R
\name{dgm_sim_from_graph}
\alias{dgm_sim_from_graph}
\title{Simulate observations from a decomposable graphical model}
\usage{
dgm_sim_from_graph(g, lvls, nsim = 1000, cell_rate = 0.5)
}
\arguments{
\item{g}{An adjacency list}

\item{lvls}{Named list with levels of the discrete variables}

\item{nsim}{Number of simulations}

\item{cell_rate}{Control discrete cell probabilities}
}
\value{
This function returns a matrix of dimension where each row correspond
to a simulated observation from a DGM represented by \code{g}.
}
\description{
Simulate observations from a decomposable graphical model
}
\examples{

g = list(
  A = c("B", "X", "Y"),
  B = c("A", "Y"),
  X = c("A", "Y"),
  Y = c("A", "X", "B")
)

lvls <- list(
  A = c("0", "1"),
  B = c("0", "1"),
  X = c("a", "b", "c"),
  Y = c("0", "1", "2")
)

dgm_sim_from_graph(g, lvls, nsim = 10)

# Converting the g to a gengraph object and plot

d <- data.frame(A = "", B = "", X = "", Y = "") # auxillary data
g <- gengraph(d, adj = g)
plot(g)

}
