% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcall.R
\name{ggcall}
\alias{ggcall}
\title{Generate code to create a `ggplot`}
\usage{
ggcall(
  data = NULL,
  mapping = NULL,
  geom = NULL,
  geom_args = list(),
  scales = NULL,
  scales_args = list(),
  coord = NULL,
  labs = list(),
  theme = NULL,
  theme_args = list(),
  facet = NULL,
  facet_args = list()
)
}
\arguments{
\item{data}{Character. Name of the \code{data.frame}.}

\item{mapping}{List. Named list of aesthetics.}

\item{geom}{Character. Name of the geom to use (without "geom_").}

\item{geom_args}{List. Arguments to use in the geom.}

\item{scales}{Character vector. Scale(s) to use (without "scale_").}

\item{scales_args}{List. Arguments to use in scale(s),
if \code{scales} is length > 1, must be a named list with \code{scales} names.}

\item{coord}{Character. Coordinates to use (without "coord_").}

\item{labs}{List. Named list of labels to use for title, subtitle, x & y axis, legends.}

\item{theme}{Character. Name of the theme to use (without "theme_").}

\item{theme_args}{List. Named list for theme arguments.}

\item{facet}{Character vector. Names of variables to use as facet.}

\item{facet_args}{List. Named list for facet arguments.}
}
\value{
a call
}
\description{
Generate code to create a `ggplot`
}
\examples{
# Default:
ggcall()

# With data and aes
ggcall("mtcars", list(x = "mpg", y = "wt"))

# Evaluate the call
library(ggplot2)
eval(ggcall("mtcars", list(x = "mpg", y = "wt")))


# With a geom:
ggcall(
  data = "mtcars", 
  mapping = list(x = "mpg", y = "wt"), 
  geom = "point"
)

# With options
ggcall(
  data = "mtcars", 
  mapping = list(x = "hp", y = "cyl", fill = "color"), 
  geom = "bar",
  coord = "flip", 
  labs = list(title = "My title"), 
  theme = "minimal", 
  facet = c("gear", "carb"),
  theme_args = list(legend.position = "bottom")
)

# One scale
ggcall(
  data = "mtcars",
  mapping = list(x = "mpg", y = "wt", color = "qsec"),
  geom = "point",
  scales = "color_distiller", 
  scales_args = list(palette = "Blues")
)

# Two scales
ggcall(
  data = "mtcars",
  mapping = list(x = "mpg", y = "wt", color = "qsec", size = "qsec"),
  geom = "point",
  scales = c("color_distiller", "size_continuous"), 
  scales_args = list(
    color_distiller = list(palette = "Greens"),
    size_continuous = list(range = c(1, 20))
  )
)
}
