% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-chooseData.R
\name{chooseData-module}
\alias{chooseData-module}
\alias{chooseDataUI}
\alias{chooseDataServer}
\title{Module for choosing data.frame}
\usage{
chooseDataUI(id)

chooseDataServer(input, output, session, data = NULL, name = NULL,
  selectVars = TRUE, coerceVars = FALSE, launchOnStart = TRUE,
  defaultData = NULL)
}
\arguments{
\item{id}{Module's id.}

\item{input}{standard \code{shiny} input.}

\item{output}{standard \code{shiny} output.}

\item{session}{standard \code{shiny} session.}

\item{data}{a data.frame to use by default.}

\item{name}{character, the name of \code{data}.}

\item{selectVars}{logical, display menu to select vars to use in selected \code{data.frame}.}

\item{coerceVars}{logical, display menu to coerce a variable in a different class.}

\item{launchOnStart}{launch modal when application is launched.}

\item{defaultData}{a character vector of \code{data.frame}s to choose along if
there is no \code{data.frame}s in Global environment. By default, \code{data.frame}s
from \code{ggplot2} are used.}
}
\value{
a \code{\link[shiny]{reactiveValues}} containing the data selected under slot \code{data}
and the name of the selected \code{data.frame} under slot \code{name}.
}
\description{
Module for choosing data.frame from
user environment and select variable to use.
}
\examples{

if (interactive()) {


library(shiny)
library(esquisse)

ui <- fluidPage(
  tags$h2("Choose data module"),
  fluidRow(
    column(
      width = 4,
      tags$h4("Default"),
      chooseDataUI(id = "choose1"),
      verbatimTextOutput(outputId = "res1")
    ),
    column(
      width = 4,
      tags$h4("No var selection"),
      chooseDataUI(id = "choose2"),
      verbatimTextOutput(outputId = "res2")
    ),
    column(
      width = 4,
      tags$h4("Default data on start"),
      chooseDataUI(id = "choose3"),
      verbatimTextOutput(outputId = "res3")
    )
  )
)

server <- function(input, output, session) {
  
  res_dat1 <- callModule(
    chooseDataServer, id = "choose1",
    launchOnStart = FALSE
  )
  output$res1 <- renderPrint({
    str(reactiveValuesToList(res_dat1))
  })
  
  res_dat2 <- callModule(
    chooseDataServer, id = "choose2", selectVars = FALSE,
    launchOnStart = FALSE
  )
  output$res2 <- renderPrint({
    str(reactiveValuesToList(res_dat2))
  })
  
  res_dat3 <- callModule(
    chooseDataServer, id = "choose3", data = iris,
    launchOnStart = FALSE
  )
  output$res3 <- renderPrint({
    str(reactiveValuesToList(res_dat3))
  })
  
}

shinyApp(ui, server)


}

}
