% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{endbutton}
\alias{endbutton}
\title{End the HTML button container}
\usage{
endbutton()
}
\value{
A character string containing the closing HTML tags for the button container.
In RMarkdown, this will ensure that the content following the button is properly
displayed. In regular R scripts, this function will return an empty string.
}
\description{
This function ends the HTML container for the button and optional toggleable content
created using the 'button()' function. When used in an RMarkdown document,
it closes the container and ensures proper rendering.
To use it, simply call the function within inline R code, do not call this function within a chunk.
}
\examples{
# In RMarkdown, use inline code (e.g., `r button()` and `r endbutton()`)
# to create a toggleable button.

if (interactive()) {
  button("Supplementary materials")
  # Hidden content goes here.
  endbutton()
}

}
