% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeShift.R
\name{makeShift}
\alias{makeShift}
\title{makeShift}
\usage{
makeShift(esDfShift, refDf, keyPromptDf, RELEVANTINFO_ES = NULL,
  RELEVANTVN_REF = NULL)
}
\arguments{
\item{esDfShift}{a list. Each element of the list must be a data.frame. This argument is generated by \code{\link{suggestShift}} if at least one ESM questionnaire is eligible for shifting to a neighboring prompt. See \strong{Details} for more information.}

\item{refDf}{a data.frame. The reference dataset.}

\item{keyPromptDf}{a data.frame. The data.frame must have exactly 2 columns. The one column's name must be SHIFTKEY (a numeric value), specifying the exact ESM questionnaire (via the use of the variable KEY). The ohter column's name must be NEW_PROMPT, specifying the new prompt index, i.e. the index after the shifting process will be over. See \strong{Details} for more information.}

\item{RELEVANTINFO_ES}{a list. This list is generated by function \code{\link{setES}}.}

\item{RELEVANTVN_REF}{a list. This list is generated by function \code{\link{setREF}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
a list with 3 data.frames, if at least one prompt was shifted, i.e.:
\enumerate{
\item the first data.frame (called 'esDf') is the raw ESM dataset in its current state (with new colum SHIFTED),
\item the second data.frame (called 'suggestShiftDf') includes all relevant information to act according to the decision as to which questionnaires shall be shifted. See \strong{Examples} to get a clear idea of how to use 'suggestShiftDf',
\item the third data.frame (called 'printShiftDf') contains the relevant information to print all questionnaires registered by \code{\link{suggestShift}} to the console, before as well as after having made the shifting. This printing to the console is done by applying the function \code{\link{printSuggestedShift}}.
}
\strong{Note}. Each questionnaire that got shifted to a neighboring prompt (which prior to the shift has not been assigned), will have its status changed, i.e. values get adapted in variables CV_ES, ES_MULT, PROMPT, and PROMPTEND.
}
\description{
makeShift can modify prompts which were assigned by the function \code{link{esAssign}}.
}
\details{
After applying \code{makeShift} the result can be checked by using the function \code{\link{printSuggestedShift}} once again.
If at least one shifting of the prompt index is suggested, use the additional data.frame, which is then is supplied by \code{\link{suggestShift}}, called 'suggestShiftDf'.' Use its 2 columns SHIFTKEY and NEW_PROMPT to generate the argument 'keyPromptDf' in function \code{makeShift}.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute makeShift. Start ----------------
# RELEVANTINFO_ES is delivered with the package
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# Use example list delivered with the package
RELEVANTVN_REF <- RELEVANTVN_REFext
# esAssigned is a list of datasets, delivered with the package. It is
# the result of the assignment of the ESM questionnaires to ALL 8
# participants in the reference dataset.
noEndDf <- missingEndDateTime(esAssigned[["ES"]], RELEVANTVN_ES)
identDf <- esIdentical(noEndDf, RELEVANTVN_ES)
sugShift <- suggestShift(identDf, 100, RELEVANTINFO_ES, RELEVANTVN_ES)
# Prerequisites in order to execute makeShift. End -------------------
# -------------------------------------------------------
# Run function 21 of 28; see esmprep functions' hierarchy.
# -------------------------------------------------------
# sugShift is the result of function 'suggestShift'. referenceDfNew is the result
# of function 'genDateTime' or of function 'splitDateTime'.
# keyPromptDf is generated by using part of the output of function suggestShift,
# i.e. by selecting the columns NEW_PROMPT and SHIFTKEY from suggestShiftDf.
keyPromptDf <- sugShift$suggestShiftDf[,c("NEW_PROMPT", "SHIFTKEY")]
madeShift <- makeShift(sugShift, referenceDfNew, keyPromptDf, RELEVANTINFO_ES, RELEVANTVN_REF)
# Tip! Display the result of function 'makeShift' in the console
# in order to check whether the shifting was successful.
printSuggestedShift(madeShift, RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 21 of 28).
}
