% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_splitcubechannels.R
\name{aux_splitcubechannels}
\alias{aux_splitcubechannels}
\title{Create multiple single-component files from multi-component files}
\usage{
aux_splitcubechannels(
  input,
  output,
  ID_in,
  component_in,
  ID_out,
  component_out,
  gipptools
)
}
\arguments{
\item{input}{\code{Character} value, path to directory where the Cube 
files to be processed are stored.}

\item{output}{\code{Character} value, path to directory where output data is 
written. It is not recommended to use the same directory for output and 
input, as files may be overwritten unintentionally.}

\item{ID_in}{\code{Character} vector with the IDs of the stations that 
will be changed. Note that for every channel of the input data, the 
corresponding ID must be repeated. See details for further information.}

\item{component_in}{\code{Character} vector with the components of the 
input stations that will be changed. The length must match the length of 
\code{ID_in} as well as \code{ID_out} and \code{component_out}.}

\item{ID_out}{\code{Character} vector with the IDs of the output files
corresponding to the input stations and components.}

\item{component_out}{\code{Character} vector with the components of the 
output stations.}

\item{gipptools}{\code{Character} value, path to gipptools or 
cubetools directory. Only needed when mseed files are processed}
}
\value{
A set of converted and organised seismic files written to disk.
}
\description{
The function changes the meta data and file names of seismic data sets
(organised in an eseis-compatible data structure). Data cubes in 
combination with splitter break-out boxes allow to record vertical 
component signals from three single-channel geophones, each connected by 
an individual cable. The logger interprets the data as E, N and Z 
components, regardless of the actual sensor and component connected to 
the respective cable. Hence, it is possible to record data from three 
independent (vertical) sensors with a single Data cube. However, the 
channels will be named according to the internal scheme (E, N, Z). To 
correct for that effect, the function will look up the right combination 
of station ID and component, and change meta data and name of each file
in the input directory accordingly, before saving the updated file in the 
output directory.
}
\examples{

\dontrun{

## the example will convert the E, N and Z components of station RUEG1
## to the station IDs RUEGA, RUEGB, RUEGC, all with BHZ as component

aux_splitcubechannels(input =  paste0(system.file("extdata", 
                                      package="eseis"), "/"), 
                      output = tempdir(), 
                      ID_in = c("RUEG1", "RUEG1", "RUEG1"), 
                      component_in = c("BHE", "BHN", "BHZ"),
                      ID_out = c("RUEGA", "RUEGB", "RUEGC"),
                      component_out = c("BHZ", "BHZ", "BHZ"))

}
                        
}
\author{
Michael Dietze
}
\keyword{eseis}
