% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_track.R
\name{spatial_track}
\alias{spatial_track}
\title{Track a spatially mobile seismic source}
\usage{
spatial_track(
  data,
  coupling,
  window,
  overlap = 0,
  d_map,
  aoi,
  v,
  q,
  f,
  k,
  qt = 1,
  dt,
  model = "SurfSpreadAtten",
  cpu,
  verbose = FALSE,
  plot = FALSE
)
}
\arguments{
\item{data}{\code{Numeric} matrix or \code{eseis} object, seismic signals 
used for source tracking. Note that the function will start tracking 
within a smaller time window, narrows be the maximum signal arrival time 
differences as defined by the maximum inter station distance and the 
seismic velocity. The signals should be the envelopes of waveforms.}

\item{coupling}{\code{Numeric}  vector, coupling efficiency factors for 
each seismic station. The best coupled station (or the one with the 
highest amplification) must receive 1, the others must be scaled 
relatively to this one.Numeric vector, coupling efficiency factors for 
each seismic station. The best coupled station (or the one with the 
highest amplification) must receive 1, the others must be scaled 
relatively to this one.}

\item{window}{\code{Numeric} value, time window for which the source is 
tracked. If omitted, ten time steps are generated.}

\item{overlap}{\code{Numeric} value between 0 and 1, fraction of overlap 
of time windows used for source tracking. Default is \code{0}.}

\item{d_map}{\code{List} object, distance maps for each station (i.e., 
\code{SpatialGridDataFrame} objects). Output of \code{spatial_distance}.}

\item{aoi}{\code{Raster} object (optional) that defines which pixels are 
used to locate the source. If omitted, the entire distance map extent is  
used. \code{aoi} and \code{d_map} objects must have the same extents, 
projections and pixel sizes. The aoi map must be of logical values.}

\item{v}{\code{Numeric} value, mean velocity of seismic waves (m/s).}

\item{q}{\code{Numeric} value, quality factor of the ground.}

\item{f}{\code{Numeric} value, frequency for which to model the 
attenuation.}

\item{k}{\code{Numeric} value, fraction of surface wave contribution to 
signals. Only relevant for models that include mixture of surface and 
body waves (see \code{model_amplitude}).}

\item{qt}{\code{Numeric} value, quantile threshold that defines acceptable
location estimates. Default is \code{1} (only single best estimate is 
kept).}

\item{dt}{\code{Numeric} value, sampling frequency. Only required if 
input signals are no eseis objects.}

\item{model}{\code{Character} value,}

\item{cpu}{\code{Numeric} value, fraction of CPUs to use for parallel 
processing. If omitted, one CPU is used}

\item{verbose}{\code{Logical} value, optional screen output of processing
progress. Default is FALSE.}

\item{plot}{\code{Logical} value, enable graphical output of key results. 
Default is \code{FALSE}.}
}
\value{
A \code{List} object with summarising statistics of the fits.
}
\description{
This function allows tracking a spatially mobile seismic source and 
thereby estimating the source amplitude and the model's variance 
reduction as a measure of quality or robustness of the time-resolved 
estimates.
}
\details{
The method is based on ideas published by Burtin et al. (2016), 
Walter et al. 82017) and Perez-Guillen et al. (2019) and implemented 
in the R package eseis by Dietze (2018). It is related to the function
\code{spatial_amplitude}, which can be used to locate spatially 
stable seismic sources by the same technique, and it resuires 
prepared input data as delivered by the function 
\code{spatial_distance}.

The input data (\code{data}) should ideally be a list of eseis 
objects (alternatively a matrix with seismic signal traces) containing 
the envelopes of the seismic event to track (i.e., describe by its 
location and amplitude as a function of propagation time). The temporal 
resolution of the track is defined by the arguments \code{window} and 
\code{overlap} (as a fraction between 0 and 1). The approach is based on 
fitting known amplitude-distance functions (for an overview of available 
functions see \code{model_amplitude}) to the envelope time snippets 
for each pixel of a grid, which provides the distance from a pixel to 
each seismic station, i.e., the distance map set \code{d_map}. To avoid 
fitting each of the pixels of the distance map, one can provide an area
of interest, AOI (\code{aoi}), which has the same extent and resolution 
as the distance map set and pixel values are either \code{TRUE} or 
\code{FALSE}. Depending on which amplitude-distance function is chosen, 
further arguments need to be provided (ground quality factor \code{q},
center frequency of the signal \code{f}). The apparent seismic wave 
velocity \code{v} is required regardless, either as fit model parameter 
or to correct the amplitude time snippets for the travel time delay from 
the source to the respective pixel of the distance map set. The output 
of the function can be provided with uncertainty estimates on all output 
values. The uncertainty is based on the size of accepted location 
estimates per time step, as defined by the variance reduction quantile 
threshold \code{qt} (i.e., all locations above this quantile will be 
assumed to be valid location estimates, whose parameters will be used 
to estimate the uncertainty). Note that usually, \code{qt} should be 
set to around 0.99, a value that depends on the number of pixels in 
the distance map set and that affects the location uncertainty, which 
in many cases is about 10 % of the average seismic station spacing. 
Note however, that this value is purely arbitrary and should be based 
on field-based control data. It is possible to run the function in a 
multi-CPU mode, to speed up computational time, using the argument 
\code{cpu}. Also, the function can generate generic plot output of 
the results, a panel of three plots: source trajectory, source 
amplitude and variance reduction.

Note that depending on the resolution of the distance map set, number 
of included seismic stations, and number of time windows, the 
function can take significant processing time. 50 time steps for 5 
stations and 5000 pixels per distance map requires about 10 minutes 
time on a normal grade computer using a single CPU.
}
\section{References}{


Burtin, A., Hovius, N., and Turowski, J. M.: Seismic monitoring of 
torrential and fluvial processes, Earth Surf. Dynam., 4, 285–307, 
https://doi.org/10.5194/esurf-4-285-2016, 2016. 

Dietze, M.: The R package 'eseis' – a software toolbox for environmental
 seismology, Earth Surf. Dynam., 6, 669–686, 
 https://doi.org/10.5194/esurf-6-669-2018, 2018. 

Perez-Guillen, C., Tsunematsu, K., Nishimura, K., and Issler, D.: Seismic 
location and tracking of snow avalanches and slush flows on Mt. Fuji, 
Japan, Earth Surf. Dynam., 7, 989–1007, 
https://doi.org/10.5194/esurf-7-989-2019, 2019. 

Walter, F., Burtin, A., McArdell, B. W., Hovius, N., Weder, B., and 
Turowski, J. M.: Testing seismic amplitude source location for fast
debris-flow detection at Illgraben, Switzerland, Nat. Hazards Earth 
Syst. Sci., 17, 939–955, https://doi.org/10.5194/nhess-17-939-2017, 2017.
}

\examples{

\dontrun{

x <- spatial_track(data = data, 
                   window = 5, 
                   overlap = 0.5,
                   d_map = D$maps, 
                   aoi = aoi, 
                   v = 800, 
                   q = 40, 
                   f = 12, 
                   qt = 0.99)

}

}
