% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_mseed.R
\name{write_mseed}
\alias{write_mseed}
\title{Write seismic traces as mseed file to disk.}
\usage{
write_mseed(data, file, time, component, station, location, network, dt)
}
\arguments{
\item{data}{\code{eseis} object or \code{numeric} vector, data set to 
be processed. Most other arguments can be omitted if \code{data} is an
\code{eseis} object.}

\item{file}{\code{Character} scalar, mseed file name with extension.}

\item{time}{\code{POSIXct} vector, time vector corresponding to the 
seismic trace. Alternatively, the start time stamp can be provided as
\code{POSIXct} value and a value for \code{dt} must be given.}

\item{component}{\code{Character} value, component ID, optional.}

\item{station}{\code{Character} value, station ID, optional.}

\item{location}{\code{Character} vector of length four, station location 
data (latitude, longitude, elevation, depth), optional.}

\item{network}{\code{Character} value, network ID, optional.}

\item{dt}{\code{Numeric} value, sampling period. Only needed if no time
vector is provided.}
}
\value{
A binary file written to disk.
}
\description{
This function converts seismic traces to mseed files and writes them to 
disk. It makes use of the Python library 'ObsPy'. Thus, this software 
must be installed, to make use of this function.
}
\details{
The ObsPy Python library can be installed following the information 
provided here: \code{"https://github.com/obspy/obspy/wiki"}.

Since the ObsPy functionality through R is not able to interpret path 
definitions using the tilde symbol, e.g. \code{"~/Downloads"}, this 
Linux type definition must be avoided.
}
\examples{

\dontrun{
## load example data 
data("rockfall")

## write as mseed file
write_mseed(data = rockfall_eseis, file = "rockfall.mseed")
          
}

}
\author{
Michael Dietze
}
