% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_clip.R
\name{time_clip}
\alias{time_clip}
\title{Clip time vector.}
\usage{
time_clip(time, limits)
}
\arguments{
\item{time}{\code{POSIXct} vector, time vector.}

\item{limits}{\code{POSIXct} vector of length two, time limits for 
clipping.}
}
\value{
\code{POSIXct} vector, clipped time vector.
}
\description{
The function clips a time vector based on provided limits.
}
\examples{

## load example data
data(rockfall)

## define limits to clip to
limits <- c(min(rockfall_t) + 10,
            max(rockfall_t) - 10)

## clip data set
rockfall_t_clip <- time_clip(time = rockfall_t, 
                             limits = limits)

## compare time ranges
range(rockfall_t)
range(rockfall_t_clip)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
