% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_getIRISstation.R
\name{aux_getIRISstation}
\alias{aux_getIRISstation}
\title{Query IRIS data base for stations}
\usage{
aux_getIRISstation(start, duration, location, radius = 10,
  component = "BHZ", ID_iris = "IrisClient")
}
\arguments{
\item{start}{\code{POSIXct} value, start time of the data to query.}

\item{duration}{\code{Numeric} value, length of the data to query, in 
seconds.}

\item{location}{\code{Numeric} vector of length two, coordinates of the 
seismic source, in decimal degrees (i.e., latitude and longitude).}

\item{radius}{\code{Numeric} value, search radius for the query, in 
decimal degrees. Default is \code{10} (about 1100 km).}

\item{component}{\code{Character} value, signal component to check for. 
One out of \code{"BHE"}, \code{"BHN"} and \code{"BHZ"}. Currently, only  
one component can be defined per search. Default is \code{"BHZ"}.}

\item{ID_iris}{\code{Character} value, IRIS ID. Default is 
\code{"IrisClient"}.}
}
\value{
\code{Data frame} with query results. The data frame contains 
information for all seismic stations fulfilling the defined criteria.
}
\description{
This function queries the IRIS data base for seismic stations that match
a set of criteria for seismic data. The criteria include signal time stamp 
and location, component and a search radius. The returned SNCL strings can 
be used to download data using the function \code{aux_getIRISdata}.
}
\details{
The function makes use of the package  IRISSeismic. It requires a working 
internet connection to perform the query.
}
\examples{

\dontrun{

x <- aux_getIRISstation(start = as.POSIXct("2010-01-01 22:22:22", 
                         tz = "UTC"), 
                         duration = 3 * 3600, 
                         location = c(53, 13), 
                         radius = 1, 
                         component = "BHZ")
}
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
