% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_mean.R
\name{meta_mean}
\alias{meta_mean}
\title{Estimate a meta-analytic mean across multiple single-group studies.}
\usage{
meta_mean(
  data,
  means,
  sds,
  ns,
  labels = NULL,
  moderator = NULL,
  contrast = NULL,
  effect_label = "My effect",
  reference_mean = 0,
  reported_effect_size = c("mean_difference", "smd_unbiased", "smd"),
  random_effects = TRUE,
  conf_level = 0.95
)
}
\arguments{
\item{data}{A dataframe or tibble}

\item{means}{A collection of study means, 1 per study}

\item{sds}{A collection of study standard deviations, 1 per study, all >0}

\item{ns}{A collection of sample sizes, 1 per study, all integers > 2}

\item{labels}{An optional collection of study labels}

\item{moderator}{An optional factor to analyze as a categorical moderator,
must have k > 2 per groups}

\item{contrast}{An optional contrast to estimate between moderator levels;
express as a vector of contrast weights with 1 weight per moderator level.}

\item{effect_label}{Optional character giving a human-friendly name of
the effect being synthesized}

\item{reference_mean}{Optional reference mean, defaults to 0}

\item{reported_effect_size}{Character specifying effect size to return; Must
be one of 'mean_difference', 'smd_unbiased' (to return an unbiased Cohen's
d1) or 'smd' (to return Cohen's d1 without correction for bias)}

\item{random_effects}{TRUE for random effect model; FALSE for fixed effects}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}
}
\value{
An esci-estimate object; a list of data frames and properties.
Returned tables include:
\itemize{
\item \strong{es_meta} - A data frame of meta-analytic effect sizes.  If a moderator was
defined, there is an additional row for each level of the moderator.
\itemize{
\item \emph{effect_label} -  Study label
\item \emph{effect_size} - Effect size
\item \emph{LL} - Lower bound of conf_level\% confidence interval
\item \emph{UL} - Upper bound of conf_level\% confidence interval
\item \emph{SE} - Expected standard error
\item \emph{k} - Number of studies
\item \emph{diamond_ratio} - ratio of random to fixed effects meta-analytic effect sizes
\item \emph{diamond_ratio_LL} - lower bound of conf_level\% confidence interval for diamond ratio
\item \emph{diamond_ratio_UL} - upper bound of conf_level\% confidence interval for diamond ratio
\item \emph{I2} -  I2 measure of heterogeneity
\item \emph{I2_LL} - Lower bound of conf_level\% confidence interval for I2
\item \emph{I2_UL} - upper bound of conf_level\% confidence interval for I2
\item \emph{PI_LL} - lower bound of conf_level\% of prediction interval
\item \emph{PI_UL} - upper bound of conf_level\% of prediction interval
\item \emph{p} - p value for the meta-analytic effect size, based on null of exactly 0
\item *width - width of the effect-size confidence interval
\item \emph{FE_effect_size} - effect size of the fixed-effects model (regardless of if fixed effects was selected
\item \emph{RE_effect_size} - effect size of the random-effects model (regardless of if random effects was selected
\item \emph{FE_CI_width} - width of the fixed-effects confidence interval, used to calculate diamond ratio
\item \emph{RE_CI_width} - width of the fixed-effects confidence interval, used to calculate diamond ratio
}
\item \strong{es_heterogeneity} - A data frame of of heterogeneity values and
conf_level\% CIs for the meta-analytic effect size.  If a moderator was defined
also reports heterogeneity estimates for each level of the moderator.
\itemize{
\item \emph{effect_label} - study label
\item \emph{moderator_variable_name} - if moderator passed, gives name of the moderator
\item \emph{moderator_level} - 'Overall' and each level of moderator, if passed
\item \emph{measure} - Name of the measure of heterogeneity
\item \emph{estimate} - Value of the heterogeneity estimate
\item \emph{LL} - lower bound of conf_level\% confidence interval
\item \emph{UL} - upper bound of conf_level\% confidence interval
}
\item \strong{raw_data} - A data from with one row for each study that was passed
\itemize{
\item \emph{label} - study label
\item \emph{effect_size} - effect size
\item \emph{weight} - study weight in the meta analysis
\item \emph{sample_variance} - expected level of sampling variation
\item \emph{SE} - expected standard error
\item \emph{LL} - lower bound of conf_level\% confidence interval
\item \emph{UL} - upper bound of conf_level\% confidence interval
\item \emph{mean} - used to calculate study p value; this is the d value entered for the study
\item \emph{sd} - use to calculate study p value; set to 1 for each study
\item \emph{n} - study sample size
\item \emph{p} - p value for the study, based on null of exactly 0
}
}
}
\description{
\code{meta_mean} is suitable for synthesizing across multiple single-group studies
with a continuous outcome variable when all studies are measured on the
same scale.
}
\details{
The meta-analytic effect size, confidence interval and heterogeneity
estimates all come from \code{\link[metafor:rma.uni]{metafor::rma()}}.

The diamond ratio and its confidence interval come from
\code{\link[=CI_diamond_ratio]{CI_diamond_ratio()}}.

If reported_effect_size is smd_unbiased or smd the conversion to d1
is handled by \code{\link[=CI_smd_one]{CI_smd_one()}}.
}
\examples{
# Data set -- see Introduction to the New Statistics, 2nd edition
data("data_mccabemichael_brain")

# Fixed effect, 95\% CI
estimate <- esci::meta_mean(
  data = esci::data_mccabemichael_brain,
  means = "M Brain",
  sds = "s Brain",
  ns = "n Brain",
  labels = "Study name",
  random_effects = FALSE
)

myplot_forest <- esci::plot_meta(estimate)


# Add a moderator, report cohen's d1
estimate_moderator_d <- esci::meta_mean(
  data = esci::data_mccabemichael_brain,
  means = "M Brain",
  sds = "s Brain",
  ns = "n Brain",
  labels = "Study name",
  moderator = "Research group",
  reported_effect_size = "smd_unbiased",
  random_effects = FALSE
)

# Forest plot
myplot_forest_moderator_d <- esci::plot_meta(estimate_moderator_d)


}
