% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_magnitude.R
\name{plot_proportion}
\alias{plot_proportion}
\title{Plot an estimated proportion}
\usage{
plot_proportion(
  estimate,
  error_layout = c("halfeye", "eye", "gradient", "none"),
  error_scale = 0.3,
  error_normalize = c("groups", "all", "panels"),
  rope = c(NA, NA),
  plot_possible = FALSE,
  ggtheme = NULL
)
}
\arguments{
\item{estimate}{\itemize{
\item An esci_estimate object generated by
\code{\link[=estimate_proportion]{estimate_proportion()}}
}}

\item{error_layout}{\itemize{
\item Optional; One of 'halfeye', 'eye', 'gradient' or 'none'
for how expected sampling error of the measure of central tendency should
be displayed.  \strong{Caution - the displayed error distributions do not seem
correct yet}
}}

\item{error_scale}{\itemize{
\item Optional real number > 0 specifying width of the expected
sampling error visualization; default is 0.3
}}

\item{error_normalize}{\itemize{
\item Optional; One of 'groups' (default), 'all', or
'panels' specifying how width of expected sampling error distributions
should be calculated.
}}

\item{rope}{\itemize{
\item Optional two-item vector specifying a region of practical
equivalence (ROPE) to be highlighted on the plot.  For a point null
hypothesis, pass the same value (e.g. c(0, 0) to test a point null of
exactly 0); for an interval null pass ascending values (e.g. c(-1, 1))
}}

\item{plot_possible}{\itemize{
\item Boolean; defaults to FALSE; TRUE to plot lines at each
discrete proportion possible given the sample size (e.g for a proportion
with 10 total cases, would draw lines at 0, .1, .2, etc.)
}}

\item{ggtheme}{\itemize{
\item Optional ggplot2 theme object to control overall styling;
defaults to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}
}}
}
\value{
Returns a ggplot object
}
\description{
\code{plot_proportion} creates a ggplot2 plot suitable for visualizing an
estimated proportion from a categorical variable. This function can be passed
an esci_estimate object generated by \code{\link[=estimate_proportion]{estimate_proportion()}}
}
\details{
This function was developed primarily for student use within jamovi when
learning along with the text book Introduction to the New Statistics, 2nd
edition (Cumming & Calin-Jageman, 2024).

Expect breaking changes as this function is improved for general use.  Work
still do be done includes:
\itemize{
\item Revise to avoid deprecated ggplot features
\item Revise for consistent ability to control aesthetics and consistent
layer names
}
}
\examples{
# From raw data
data("data_campus_involvement")

estimate_from_raw <- esci::estimate_proportion(
  esci::data_campus_involvement,
  CommuterStatus
)


# To visualize the estimate
myplot_from_raw <- esci::plot_proportion(estimate_from_raw)


# From summary data
estimate_from_summary <- esci::estimate_proportion(
  cases = c(8, 22-8),
  outcome_variable_levels = c("Affected", "Not Affected")
)

# To visualize the estimate
myplot_from_summary<- esci::plot_proportion(estimate_from_summary)

}
