% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_boin12_obd.R
\name{select_boin12_obd}
\alias{select_boin12_obd}
\title{Select dose by BOIN12's OBD-choosing algorithm.}
\usage{
select_boin12_obd(
  parent_selector_factory,
  when = c("finally", "always"),
  tox_limit = NULL,
  ...
)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{when}{Either of: 'finally' to select dose only when the parent
dose-selector has finished, by returning continue() == FALSE; or 'always'
to use this dose-selection algorithm for every dose decision. As per the
authors' original intentions, the default is 'finally'.}

\item{tox_limit}{We seek a dose with toxicity probability no greater than.
If not provided, the value will be sought from the parent dose-selector.}

\item{...}{Extra args are ignored.}
}
\value{
an object of type \code{\link{selector_factory}}.
}
\description{
This method selects dose by the algorithm for identifying the optimal
biological dose (OBD) described in Lin et al. (2020). This class is intended
to be used when a BOIN12 trial has reached its maximum sample size. Thus, it
intends to make the final dose recommendation after the regular BOIN12 dose
selection algorithm, as implemented by \code{\link{get_boin12}}, has
gracefully concluded a dose-finding trial. However, the class can be used in
any scenario where there is a limit toxicity rate. See Examples.
Note - this class will not override the parent dose selector when the parent
is advocating no dose. Thus this class will not reinstate a dangerous dose.
}
\examples{
# This class is intended to make the final dose selection in a BOIN12 trial:
tox_limit <- 0.35
model <- get_boin12(num_doses = 5, phi_t = 0.35, phi_e = 0.25,
                    u2 = 40, u3 = 60, n_star = 6) \%>\%
  stop_at_n(n = 12) \%>\%
  select_boin12_obd()

outcomes <- '1NNN 2NTN 2NNN 3NTT'
model \%>\% fit(outcomes) \%>\% recommended_dose()

# However, since behaviour is modular in this package, we can use this method
# to select dose at every dose decision:
model2 <- get_boin12(num_doses = 5, phi_t = 0.35, phi_e = 0.25,
                    u2 = 40, u3 = 60, n_star = 6) \%>\%
  select_boin12_obd(when = 'always')
model2 \%>\% fit('1NNT') \%>\% recommended_dose()
model2 \%>\% fit('1NNN 2NNT') \%>\% recommended_dose()

}
\references{
Lin, R., Zhou, Y., Yan, F., Li, D., & Yuan, Y. (2020).
BOIN12: Bayesian optimal interval phase I/II trial design for utility-based
dose finding in immunotherapy and targeted therapies.
JCO precision oncology, 4, 1393-1402.
}
