% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{get_discrete_dist}
\alias{get_discrete_dist}
\title{Get a discretized, truncated version of a distribution}
\usage{
get_discrete_dist(params)
}
\arguments{
\item{params}{distribution params (output of \verb{def_dist_*()} function)}
}
\value{
Numeric. Vector with discretized density.
}
\description{
Get a discretized, truncated version of a distribution
}
\examples{

# Define distributions
fec = def_dist_fecal_shedding(pathogen = 'sarscov2')
gi  = def_dist_generation_interval(pathogen = 'influenza')

# Get their (discretized) densities
d.fec = get_discrete_dist(fec)
d.gi  = get_discrete_dist(gi)

print(d.fec)
print(d.gi)

}
