% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-length.R
\name{check_length}
\alias{check_length}
\title{Check Argument's Length}
\usage{
check_length(
  x,
  valid,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  interval = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{valid}{A numeric vector which contains non-negative integers and
\code{NA}, used with argument \code{interval} to indicate the valid lengths.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. \code{\link[glue:glue]{glue::glue()}} syntax can be used, see
"Examples" section. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{interval}{Optional. \code{TRUE} or \code{FALSE} which indicates if argument
\code{valid} is interpreted as an interval or as single lengths. For example,
\code{c(1, 10)} is interpreted as "larger than 1 and smaller than 10" if
\code{interval} is \code{TRUE}, but as "1 or 10" if \code{FALSE}. \code{NA} can be used in
\code{valid} when treated as interval. For example, \code{c(0, NA)} means "larger
than 0". By default, \code{interval} is inferred from \code{valid}. For example,
if \code{valid} has length unequal to 2, it's treated as single lengths.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if an argument has valid length, and if not,
generate an error message.
}
\examples{
\dontrun{
x <- c(1, 2)

# `valid` as interval
check_length(x, c(1, 3), interval = TRUE)
check_length(x, c(NA, 2))

# `valid` as single lengths
check_length(x, c(1, 3), interval = FALSE)

# customize error message with `glue::glue()` syntax
specific <- "Oh my god! `{name}`'s length is {feature}."
check_length(x, 3, specific = specific)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
