% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_stats.R
\name{geodesic}
\alias{geodesic}
\alias{geodesita}
\alias{geodesic.list}
\alias{geodesic.matrix}
\alias{geodesic.network}
\title{Geodesic distance matrix (all pairs)}
\usage{
geodesic(x, force = FALSE, ...)

geodesita(x, force = FALSE, ...)

\method{geodesic}{list}(x, force = FALSE, ...)

\method{geodesic}{matrix}(x, force = FALSE, simplify = FALSE, ...)

\method{geodesic}{network}(x, force = FALSE, simplify = FALSE, ...)
}
\arguments{
\item{x}{Either a list of networks (or square integer matrices), an integer
matrix, a network, or an ergmito.}

\item{force}{Logical scalar. If \code{force = FALSE} (the default) and \code{nvertex(x) > 100}
it returns with an error. To force computation use \code{force = TRUE}.}

\item{...}{Further arguments passed to the method.}

\item{simplify}{Logical scalar. When \code{TRUE} it returns a matrix, otherwise,
a list of length \code{nnets(x)}.}
}
\description{
Calculates the shortest path between all pairs of vertices in a network.
This uses the power matrices to do so, which makes it efficient only for
small networks.
}
\examples{
data(fivenets)
geodesic(fivenets)
}
