% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R
\name{ergmReference}
\alias{ergmReference}
\alias{ergm-references}
\alias{references-ergm}
\alias{ergm.references}
\alias{references.ergm}
\title{Reference Measures for Exponential-Family Random Graph Models}
\description{
This page describes how to specify the reference measures (baseline distributions)
(the set of possible networks \eqn{Y} and the baseline weights \eqn{h(y)} to functions in the \code{\link[=ergm-package]{ergm}}
package. It also provides an indexed list of the references visible to the \CRANpkg{ergm}'s API. References can also be searched via \code{\link[=search.ergmReferences]{search.ergmReferences()}}, and help for an individual reference can be obtained with \verb{ergmReference?<reference>} or \code{help("<reference>-ergmReference")}.

\insertNoCite{HuHa08e,Kr12e}{ergm}
}
\section{Specifying reference measures}{

\ERGMspec

The reference measure \eqn{(Y,h(y))} is specified on the right-hand side of a one-sided formula passed
typically as the \code{reference} argument.
}

\section{Reference measures visible to the package}{


\ergmCSS

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexLatex(ergm:::.buildTermsDataframe("ergmReference"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexText(ergm:::.buildTermsDataframe("ergmReference"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexHtml(ergm:::.buildTermsDataframe("ergmReference"))}}
\subsection{All references}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixLatex(ergm:::.termMatrix("ergmReference"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixText(ergm:::.termMatrix("ergmReference"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixHtml(ergm:::.termMatrix("ergmReference"))}}
}

\subsection{References by keywords}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocLatex(ergm:::.termToc("ergmReference"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocText(ergm:::.termToc("ergmReference"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocHtml(ergm:::.termToc("ergmReference"))}}
}
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=ergm-package]{ergm}}, \code{\link[network:network]{network}}, \CRANpkg{sna}, \code{\link{summary.ergm}}, \code{\link{print.ergm}}, \verb{\\\%v\\\%}, \verb{\\\%n\\\%}
}
\keyword{models}
