% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{b2factor-ergmTerm}
\alias{b2factor-ergmTerm}
\alias{InitErgmTerm.b2factor}
\alias{InitWtErgmTerm.b2factor}
\title{Factor attribute effect for the second mode in a bipartite network}
\usage{
# binary: b2factor(attr, base=1, levels=-1)

# valued: b2factor(attr, base=1, levels=-1, form="sum")
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{base}{deprecated}

\item{levels}{this optional argument controls which levels of the attribute should be included and which should be excluded. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{form}{how to aggregate tie values in a valued ERGM: \code{"sum"}
(the default) for a statistic of the form \eqn{\sum_{i,j} x_{i,j}
  y_{i,j}}{sum[i,j] x[i,j]*y[i,j]}, where \eqn{y_{i,j}}{y[i,j]} is
the value of dyad \eqn{(i,j)} and \eqn{x_{i,j}}{x[i,j]} is the
term's covariate associated with it; and \code{"nonzero"} with the
edge considered to be present if its value is not 0. See
\code{\link{ergmTerm}} for more information.}
}
\description{
This term adds multiple network statistics to the model, one for each of (a subset of) the
unique values of the \code{attr} attribute. Each of these statistics
gives the number of times a node with that attribute in the second mode of
the network appears in an edge. The second mode of a bipartite network
object is sometimes known as the "event" mode.
}
\note{
To include all attribute values is usually not a good idea, because
the sum of all such statistics equals the number of edges and hence a linear
dependency would arise in any model also including \code{edges}. The default,
\code{levels=-1}, is therefore to omit the first (in lexicographic order)
attribute level. To include all levels, pass either \code{levels=TRUE}
(i.e., keep all levels) or \code{levels=NULL} (i.e., do not filter levels).

The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.

This term can only be used with undirected bipartite networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2factor", "subsection")}
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{dyad-independent}
\concept{frequently-used}
\concept{undirected}
