% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.networks.R
\name{uncombine_network}
\alias{uncombine_network}
\title{Split up a network into a list of subgraphs}
\usage{
uncombine_network(
  nw,
  ignore.nattr = c("bipartite", "directed", "hyper", "loops", "mnext", "multiple", "n",
    ".subnetcache"),
  ignore.vattr = c(),
  ignore.eattr = c(),
  split.vattr = ".NetworkID",
  names.vattr = NULL
)
}
\arguments{
\item{nw}{a \code{\link[network:network]{network::network}} created by \code{\link[=combine_networks]{combine_networks()}}.}

\item{ignore.nattr, ignore.vattr, ignore.eattr}{network, vertex, and
edge attributes not to be processed as described below.}

\item{split.vattr}{name of the vertex attribute on which to split.}

\item{names.vattr}{optional name of the vertex attribute to use as network
names in the output list.}
}
\value{
a list of \code{\link[network:network]{network::network}}s containing subgraphs on \code{split.vattr}. In particular,
\itemize{
\item their basic properties (directedness and bipartednes) are the same as those of the input network;
\item vertex attributes are split;
\item edge attributes are assigned to their respective edges in
the returned networks.
}

If \code{split.vattr} is a vector, only the first element is used and it's "popped".
}
\description{
Given a network created by \code{\link[=combine_networks]{combine_networks()}}, \code{\link[=uncombine_network]{uncombine_network()}} returns a list of networks,
preserving attributes that can be preserved.
}
\examples{

data(samplk)

o1 <- combine_networks(list(samplk1, samplk2, samplk3))
image(as.matrix(o1))

ol <- uncombine_network(o1)

}
\seealso{
\code{\link[=split.network]{split.network()}}
}
