% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erfeVecR.R
\name{erfeVecR}
\alias{erfeVecR}
\title{Dexpectilize a vector according the a single asymmetric point}
\usage{
erfeVecR(xmat, yvec, panSizeVec, asym, id)
}
\arguments{
\item{xmat}{Numeric vector to de-expectilize.}

\item{yvec}{Numeric vector of individual asymmetric weight.}

\item{panSizeVec}{Numeric vector to individual panel size.}

\item{asym}{Numeric vector to individual panel size.}

\item{id}{Numeric vector to individual panel size.}
}
\value{
Return a list of objects related to the erfe model
such as the asymmetric point, the coefficient-estimate,
the standard deviation, the estimated covariance.
}
\description{
This function is part of the erfe package. It estimates
 the ERFE model for a panel dataset and for a
 single asymmetric point \eqn{\tau \in (0, 1)}.
 When \eqn{\tau=0.5} the function estimate the classical
 within-transformation estimator and its sandwich
 covariance matrix.
}
\examples{
set.seed(13)
temps_obs <- 5
n_subj <- 50
sig <- diag(rep(1,temps_obs))
id <- rep(1:n_subj, each=temps_obs)
rvec <- c(mvtnorm::rmvnorm(n_subj, sigma = sig))
fvec <- (1 + rep(rnorm(n_subj) , each=temps_obs))
xmat <- cbind(rt(n_subj*temps_obs, df=2, ncp=1.3),
 1.2 * fvec + rnorm(n_subj * temps_obs, mean = 0.85, sd = 1.5) )
yvec <- 0.6*xmat[, 1] + xmat[, 2] + fvec + rvec
asym <- 0.5
panSizeVec <- unname(unlist(lapply(split(id, id), function(x) length(x))))
erfeVecR(xmat, yvec, panSizeVec, asym, id)
}
\references{
Barry, Amadou, Oualkacha, Karim, and Charpentier 
 Arthur. (2022). \emph{Weighted asymmetric least squares
  regression with fixed-effects}.
 arXiv preprint arXiv:2108.04737
}
\author{
Amadou Barry, \email{barryhafia@gmail.com}
}
