% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.summary_table_2_1}
\alias{.summary_table_2_1}
\title{Wrapper for the repetitive code in function_table_2_1. Data frame summary}
\usage{
.summary_table_2_1(df, group_by)
}
\arguments{
\item{df}{A data frame}

\item{group_by}{A character vector of variables in `df` to group by. Should contain 'eq5d' and 'fu'.}
}
\value{
A summarised data frame with groups defined by `eq5d` and `fu` variables, the count of observations in each group, and the frequency of each group.
}
\description{
This internal function summarises a data frame by grouping it based on the variables specified in the 'group_by' argument and calculates the frequency of each group. The output is used in Table 2.1
}
\examples{
set.seed(1234)
df <- data.frame(eq5d = rep(rnorm(5), 2),
                 fu = rep(c(1, 0, 1, 0, 1), 2))
.summary_table_2_1(df, c("eq5d", "fu"))
}
