% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcEnrichment.R
\name{plotDSEA}
\alias{plotDSEA}
\title{Plotting functions for DSEA lists}
\usage{
plotDSEA(dsepso, dsesso, dsepi, dsepisem, dsfenics, dsspace, k)
}
\arguments{
\item{dsepso}{list with enrichment for EpSO}

\item{dsesso}{list with enrichment for ESSO}

\item{dsepi}{list with enrichment for EPILONT}

\item{dsepisem}{list with enrichment for EPISEM}

\item{dsfenics}{list with enrichment for FENICS}

\item{dsspace}{list with enrichment for the combined ranked list}

\item{k}{numeric value for the length to be plotted}
}
\value{
the plot object
}
\description{
Plotting functions for DSEA lists
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
utils::data(rawDrugNamesCoOcEPISEM, package="epos")
utils::data(rawDrugNamesCoOcFENICS, package="epos")
atchashda <-
    readAtcMapIntoHashMapDrugNamesAtcCodes(
        system.file("extdata", "db-atc.map", package = "epos"), "\t")
epso <- rawDrugNamesCoOcEpSO
neuroepso <- filterNeuroDrugs(epso, atchashda)
esso <- rawDrugNamesCoOcESSO
neuroesso   <- filterNeuroDrugs(esso, atchashda)
epi <- rawDrugNamesCoOcEPILONT
neuroepi    <- filterNeuroDrugs(epi, atchashda)
episem <- rawDrugNamesCoOcEPISEM
neuroepisem <- filterNeuroDrugs(episem, atchashda)
fenics <- rawDrugNamesCoOcFENICS
neurofenics <- filterNeuroDrugs(fenics, atchashda)
mx <- max(
    c(length(neuroepso), length(neuroesso), length(neuroepi),
      length(neuroepisem), length(neurofenics)))
dneuro <-
  data.frame(EpSO = c(neuroepso, rep("", (mx-length(neuroepso)))),
             ESSO = c(neuroesso, rep("", (mx-length(neuroesso)))),
             EPILONT = c(neuroepi, rep("", (mx-length(neuroepi)))),
             EPISEM = c(neuroepisem, rep("", (mx-length(neuroepisem)))),
             FENICS = c(neurofenics, rep("", (mx-length(neurofenics)))))
dneuromaxk <- TopKLists::calculate.maxK(dneuro, L=5, d=5, v=5)
neurospace <- as.character(dneuromaxk$topkspace)
dsepso <- calcDSEA(neuroepso, mx)
dsesso <- calcDSEA(neuroesso, mx)
dsepi <- calcDSEA(neuroepi, mx)
dsepisem <- calcDSEA(neuroepisem, mx)
dsfenics <- calcDSEA(neurofenics, mx)
dsspace  <-  calcDSEA (neurospace, mx)
p <- plotDSEA(dsepso, dsesso, dsepi, dsepisem, dsfenics, dsspace, dneuromaxk$maxK)
\dontrun{
ggplot2::ggsave("dsea.png", 
   p <- plotDSEA(dsepso, dsesso, dsepi, dsepisem, dsfenics, dsspace, 
   dneuromaxk$maxK), width=480, height=320, units = "mm", dpi = 300)
}
}
