% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd.R
\name{eGFR_adult_SCr}
\alias{eGFR_adult_SCr}
\alias{eGFR_adult_SCr.data.frame}
\alias{eGFR_adult_SCr.units}
\alias{eGFR_adult_SCr.numeric}
\title{eGFR 2009 CKD-EPI creatinine equation}
\usage{
eGFR_adult_SCr(...)

\method{eGFR_adult_SCr}{data.frame}(.data, SCr, Age, male, black, ...)

\method{eGFR_adult_SCr}{units}(SCr, Age, male, black, ...)

\method{eGFR_adult_SCr}{numeric}(SCr, Age, male, black, ...)
}
\arguments{
\item{...}{Further optional arguments}

\item{.data}{(data.frame) A data.frame, optional}

\item{SCr}{Serum creatinine
column name, or vector of units or numeric if \code{.data} is not provided}

\item{Age}{Age of patient
column name, or vector of units or numeric if \code{.data} is not provided}

\item{male}{Male or not
column name, or vector of logical (TRUE/FALSE) if \code{.data} is not provided}

\item{black}{Black race or not
column name, or vector of logical (TRUE/FALSE) if \code{.data} is not provided}
}
\value{
Estimated GFR
of the same type provided (numeric or units)
}
\description{
Using KDIGO 2012 Clinical Practice Guideline for
the Evaluation and Management of Chronic Kidney Disease
Volume 3 | Issue 1 | January 2013
}
\details{
See \url{https://kdigo.org/guidelines/ckd-evaluation-and-management/} for more details
}
\examples{
eGFR_adult_SCr(eGFR_pt_data,
  SCr = "SCr_", Age = "Age_", male = "male_", black = "black_"
)

eGFR_pt_data \%>\%
  dplyr::mutate(eGFR = eGFR_adult_SCr(
    SCr = SCr_, Age = Age_, male = male_, black = black_
  ))
}
