% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eply.R
\name{eply}
\alias{eply}
\title{Function \code{eply}}
\usage{
eply(.fun, .expr, .with = parent.frame())
}
\arguments{
\item{.fun}{function to evaluate.}

\item{.expr}{data frame of quoted expressions. Column names must
contain the argument names of \code{.fun}.}

\item{.with}{list, data frame, or environment with the
data accessible to \code{.expr}}
}
\value{
a list or vector of return values of \code{.fun}.
}
\description{
Apply a function over a data frame of quoted expressions.
Parallel execution is available using the \code{.split} and \code{.tasks} arguments.
}
\details{
\code{.fun} is a function, and \code{.expr} is a data frame. 
In \code{.expr}, each row stands for a single call to \code{.fun}, and each
column stamds for an argument. Each element is a quoted expression that 
uses the data in \code{.with} during evaluation.
When \code{\link{eply}} is called on each row, the expressions 
are evaluated on \code{.with}, 
and the results are given to \code{.fun} as function arguments. 
The column names of \code{.expr} must
contain the argument names of \code{.fun}.
With \code{.tasks} and \code{.split}, Mac and Linux users can 
distribute the work over multple parallel tasks. See the vignette for an 
example (\code{vignette("eply")}).
}
\seealso{
\code{\link{evals}}, \code{\link{help_eply}}
}

