% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{eplus_sql}
\alias{eplus_sql}
\title{Read an Energy SQLite Output File}
\usage{
eplus_sql(sql)
}
\arguments{
\item{sql}{A path to an local EnergyPlus SQLite output file.}
}
\value{
An \code{EplusSql} object.
}
\description{
\code{eplus_sql()} takes an EnergyPlus SQLite output file as input, and returns an
\code{EplusSQL} object for collecting simulation outputs. For more details,
please see \link{EplusSql}.
}
\examples{
\dontrun{
if (is_avail_eplus(8.8)) {
    idf_name <- "1ZoneUncontrolled.idf"
    epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"

    idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
    epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)

    # copy to tempdir and run the model
    idf <- read_idf(idf_path)
    idf$run(epw_path, tempdir())

    # create from local file
    sql <- eplus_sql(file.path(tempdir(), "1ZoneUncontrolled.sql"))
}
}
}
\author{
Hongyuan Jia
}
