% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.R
\docType{class}
\name{job}
\alias{job}
\title{Run EnergyPlus Simulation and Collect Outputs}
\description{
\code{EplusJob} class wraps the EnergyPlus command line interface and provides
methods to extract simulation outputs.
}
\details{
eplusr uses the EnergyPlus SQL output for extracting simulation outputs. In
order to do so, a object in \code{Output:SQLite} with \code{Option Type} value of
\code{SimpleAndTabular} will be automatically created if it does not exists.
\code{EplusJob} has provide some wrappers that do SQL query to get report data
results, i.e. results from \code{Output:Variable} and \code{Output:Meter*}. But for
\code{Output:Table} results, you have to be familiar with the structure of the
EnergyPlus SQL results, especially for table \emph{"TabularDataWithStrings"}. For
details, please see \emph{"2.20 eplusout.sql"}, especially \emph{"2.20.4.4 TabularData
Table"} in EnergyPlus \emph{"Output Details and Examples"} documentation.
}
\section{Usage}{
\preformatted{job$run(wait = TRUE)
job$kill()
job$status()

job$errors(info = FALSE)

job$output_dir(open = FALSE)
job$locate_output(suffix = ".err", strict = TRUE)
job$report_data_dict()
job$report_data(key_value = NULL, name = NULL, year = NULL, tz = "GMT", case = "auto")
job$tabular_data()

job$print()
}
}

\section{Create}{
\preformatted{job <- eplus_job(idf, epw)
}

\strong{Arguments}
\itemize{
\item \code{idf}: Path to EnergyPlus IDF or IMF file or an \code{Idf} object.
\item \code{epw}: Path to EnergyPlus EPW file or an \code{Epw} object.
}
}

\section{Run}{
\preformatted{job$run(wait = TRUE)
job$kill()
job$status()
}

\code{$run} runs the simulation using input model and weather file.

\code{$kill} kills the background EnergyPlus process if possible. It only
works when simulation runs in waiting mode.

\code{$status} returns a named list of values indicates the status of the job:
\itemize{
\item \code{run_before}: \code{TRUE} if the job has been run before.
\item \code{changed_after}: \code{TRUE} if the IDF file has been changed since last
simulation.
\item \code{terminated}: \code{TRUE} if the simulation was terminated during last
simulation.
\item \code{successful}: \code{TRUE} if last simulation ended successfully.
\item \code{alive}: \code{TRUE} if the simulation is still running in the background.
\item \code{wait}: \code{TRUE} if the simulation was run in waiting mode last time.
}

\strong{Arguments}
\itemize{
\item \code{echo}: Only applicable to \code{run_idf}. Show EnergyPlus simulation process
information to the console.  If \code{FALSE}, which is default, a
\link[processx:process]{processx::process} object will be return.
\item \code{wait}: If \code{TRUE}, R will hang on and wait for the simulation to complete.
Output from EnergyPlus command line interface will be printed into the
console as well. If \code{FALSE}, simulation will be run in a background
process. Default: \code{TRUE}.
}
}

\section{Results Extraction}{
\preformatted{job$output_dir(open = FALSE)
job$locate_output(suffix = ".err", strict = TRUE)
job$report_data_dict()
job$report_data(key_value = NULL, name = NULL, year = NULL, tz = "GMT", case = "auto")
job$tabular_data()
}

\code{$output_dir} returns the output directory of simulation results.

\code{$locate_output} returns the path of a single output file specified by file
suffix.

\code{$report_data_dict} returns a data.table which contains all information about
report data. For details on the meaning of each columns, please see
"2.20.2.1 ReportDataDictionary Table" in EnergyPlus "Output Details and
Examples" documentation.

\code{$report_data} extracts the report data using key values and variable names.

\code{$tabular_data} extracts all tabular data.

\strong{Arguments}:
\itemize{
\item \code{open}: If \code{TRUE}, the output directory will be opened. It may only work
well on Windows.
\item \code{suffix}: A string that indicates the file suffix of simulation output.
Default: \code{".err"}.
\item \code{strict}: If \code{TRUE}, it will check if the simulation was terminated, is
still running or the file exists or not. Default: \code{TRUE}.
\item \code{key_value}: A character vector to identify key name of the data. If
\code{NULL}, all keys of that variable will be returned. Default: \code{NULL}.
\item \code{name}: A character vector to specify the actual data name. If \code{NULL}, all
variables will be returned. Default: \code{NULL}.
\item \code{year}: The year of the date and time in column \code{DateTime}. If \code{NULL}, it
will be the current year. Default: \code{NULL}
\item \code{tz}: Time zone of date and time in column \code{DateTime}. Default: \code{"GMT"}.
\item \code{case}: If not \code{NULL}, a character column will be added indicates the case
of this simulation. If \code{"auto"}, the name of the IDF file will be used.
}
}

\seealso{
\link[=param]{ParametricJob class} for EnergyPlus parametric simulations.
}
\author{
Hongyuan Jia
}
