% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_eplus}
\alias{install_eplus}
\alias{uninstall_eplus}
\alias{download_eplus}
\title{Download and Install EnergyPlus}
\usage{
install_eplus(ver = "latest", local = FALSE, dir = NULL, force = FALSE, ...)

uninstall_eplus(ver)

download_eplus(ver = "latest", dir)
}
\arguments{
\item{ver}{The EnergyPlus version number, e.g., \code{8.7}. For \code{download_eplus()}
and \code{install_eplus()}, the special value \code{"latest"}, which is the
default, means the latest version supported by eplusr.}

\item{local}{Whether to install EnergyPlus only for current user. For Windows
and Linux, if \code{FALSE}, administrative privileges are required to
install EnergyPlus to the default system-level location. See details.
\code{local} should be also set to \code{FALSE} if you do not have the write
access to the directory specified via \code{dir}. Default: \code{FALSE}. For
macOS, administrative privileges are always required no matter you
want EnergyPlus to be install at \verb{/Applications} or \verb{~/Applications}.}

\item{dir}{A single string of directory.
\itemize{
\item For \code{download_eplus()}, where to save EnergyPlus installer file.
Default: \code{"."}.
\item For \code{install_eplus()}, the installer will always be saved into
\code{\link[=tempdir]{tempdir()}}. But you can use \code{dir} to specify the \strong{parent} directory
of EnergyPlus installation, i.e. the \strong{parent} directory of
\code{EnergyPlusVX-Y-0} on Windows and \code{EnergyPlus-X-Y-0} on Linux. macOS is
not supported. If \code{NULL}, the default installation path will be used.
See details for more information. Please note that \code{dir} does not work
on macOS and EnergyPlus will always be installed into the default
location. Default: \code{NULL}.
}}

\item{force}{Whether to install EnergyPlus even if it has already been
installed. Setting to \code{TRUE} if you want to install the downloaded
EnergyPlus anyway. Please note that this may results in multiple
EnergyPlus installations of the same version at different locations.
eplusr will only use the first EnergyPlus installation. Default: \code{FALSE}.}

\item{...}{Other arguments to be passed to the installer. Current only one
additional argument exists and is only for Linux:
\itemize{
\item \code{dir_bin}: A path where symbolic links will be created to the software
executables. The default is \verb{/usr/local/bin} if \code{local} is \code{FALSE}
and \verb{~/.local/bin} if \code{local} is \code{TRUE}.
}}
}
\value{
An invisible integer \code{0} if succeed. Moreover, some attributes will
also be returned:
\itemize{
\item For \code{install_eplus()}:
\itemize{
\item \code{path}: the EnergyPlus installation path
\item \code{installer}: the path of downloaded EnergyPlus installer file
}
\item For \code{download_eplus()}:
\itemize{
\item \code{file}: the path of downloaded EnergyPlus installer file
}
}
}
\description{
Download specified version of EnergyPlus for your platform from GitHub and
install it.
}
\details{
\code{download_eplus()} downloads specified version of EnergyPlus from
\href{https://github.com/NREL/EnergyPlus}{EnergyPlus GitHub Repository}.

\code{install_eplus()} tries to install EnergyPlus into the default location,
e.g. \verb{C:\EnergyPlusVX-Y-0} on Windows, \verb{/usr/local/EnergyPlus-X-Y-0} on
Linux, and \verb{/Applications/EnergyPlus-X-Y-0} on macOS.

Note that installing to the default location requires administrative
privileges and you have to run R with administrator (or with sudo if you are
on Linux) to make it work if you are not in interactive mode.

If you can't run R with administrator, it is possible to install EnergyPlus
to your home corresponding directory by setting \code{local} to \code{TRUE}.

The user level EnergyPlus installation path is:
\itemize{
\item Windows:
\itemize{
\item \code{dir(Sys.getenv("LOCALAPPDATA"), "EnergyPlusVX-Y-0")} OR
\item \verb{C:\Users\<User>\AppData\Local\EnergyPlusVX-Y-0} if environment
variable \code{"LOCALAPPDATA"} is not set
}
\item macOS: \verb{/Users/<User>/Applications/EnergyPlus-X-Y-0}
\item Linux: \code{"~/.local/EnergyPlus-X-Y-0"}
}

On Windows and Linux, you can also specify your custom directory using the
\code{dir} argument. Remember to change \code{local} to \code{FALSE} in order to ask for
administrator privileges if you do not have the write access to that
directory.

Please note that when \code{local} is set to \code{FALSE}, no symbolic links
will be created, since this process requires administrative privileges.

\code{uninstall_eplus()} tries to uninstall specified version of EnergyPlus
located by eplusr. Similar as \code{install_eplus()}, administrative privileges
may be required.
}
\examples{
\dontrun{
# download the latest version of EnergyPlus
download_eplus("latest", dir = tempdir())
# install the latest version of EnergyPlus system-wide which is the default
# and requires administrative privileges
install_eplus("latest")

# for a specific version of EnergyPlus
download_eplus(8.8, dir = tempdir())
install_eplus(8.8)

# force to reinstall
install_eplus(8.8, force = TRUE)

# install EnergyPlus in your home directory
install_eplus(8.8, local = TRUE, force = TRUE)

# custom EnergyPlus install home directory
install_eplus(8.8, dir = "~/MyPrograms", local = TRUE, force = TRUE)
}
}
\author{
Hongyuan Jia
}
