% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{del_idf_object}
\alias{del_idf_object}
\title{Delete existing objects}
\usage{
del_idf_object(
  idd_env,
  idf_env,
  dt_object,
  ref_to = FALSE,
  ref_by = FALSE,
  recursive = FALSE,
  force = FALSE,
  level = eplusr_option("validate_level")
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{dt_object}{A \code{\link[data.table:data.table]{data.table::data.table()}} that contains object data.}

\item{ref_to}{If \code{TRUE}, objects whose fields are referred by input
objects will also be deleted. Default: \code{FALSE}.}

\item{ref_by}{If \code{TRUE}, objects whose fields refer to input objects
will also be deleted. Default: \code{FALSE}.}

\item{recursive}{If \code{TRUE}, relation searching is performed
recursively, in case that objects whose fields refer to target
object are also referred by another object, and also objects
whose fields are referred by target object are also referred
by another object. Default: \code{FALSE}.}

\item{force}{If \code{TRUE}, objects are deleted even if they are
referred by other objects.}

\item{level}{Validate level. Default: \code{eplusr_option("validate_level")}.}
}
\value{
The modified \link{Idf} data in a named list of 5 elements, i.e. \code{object},
\code{value}, \code{reference}, \code{changed} and \code{updated}. First 3 elements are
\code{\link[data.table:data.table]{data.table::data.table()}}s containing the actual updated \link{Idf} data while
\code{changed} and \code{updated} are integer vectors containing IDs of objects that
have been directly changed and indirectly updated due to references,
respectively.
}
\description{
Delete existing objects
}
\keyword{internal}
