% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{init_idf_object}
\alias{init_idf_object}
\title{Initialize object data}
\usage{
init_idf_object(
  idd_env,
  idf_env,
  class,
  property = NULL,
  underscore = FALSE,
  id = TRUE,
  name = TRUE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{class}{An integer vector of valid class indexes or a character vector
of valid class names. Default: \code{NULL}.}

\item{property}{A character vector of column names in class table to return.}

\item{underscore}{If \code{TRUE}, input class name will be converted into
underscore style name first and column \code{class_name_us} will be used
for matching. Default: \code{FALSE}.}

\item{id}{If \code{TRUE}, new object IDs will be added in column \code{object_id} based
on current existing objects found in \code{idf_env}. Default: \code{TRUE}.}

\item{name}{If \code{TRUE}, column \code{object_name} and \code{object_name_lower} will be
filled using \code{\link[=make_idf_object_name]{make_idf_object_name()}}. Default: \code{TRUE}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}}
}
\description{
Initialize object data
}
\keyword{internal}
