% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{expand_idf_dots_value}
\alias{expand_idf_dots_value}
\title{Parse object field values given in list format}
\usage{
expand_idf_dots_value(
  idd_env,
  idf_env,
  ...,
  .type = "class",
  .complete = TRUE,
  .all = FALSE,
  .scalar = TRUE,
  .pair = FALSE,
  .ref_assign = TRUE,
  .unique = TRUE,
  .empty = TRUE,
  .default = TRUE,
  .env = parent.frame()
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{...}{Lists of object definitions. Each list should be named
with a valid class/object id/name. ID should be denoted in style
\code{..ID}. There is a special element \code{.comment} in each list, which will
be used as new comments of the object. If \code{.ref_assign} is \code{TRUE},
\verb{:=} can be used to group ids/names:
\itemize{
\item When \code{.type} equals \code{"class"}, LHS multiple class indices/names should be
wrapped by \code{.()}, \code{c()}.
\item When \code{.type} equals \code{"object"}, LHS multiple object ids/names should be
wrapped by \code{.()} or \code{c()}. LHS \strong{SINGLE} class name should be
wrapped by \code{..()}.
}}

\item{.type}{Should be either \code{"class"} or \code{"object"}. If \code{"class"},
id/name of each input will be treated as class index/name. If \code{"object"},
id/name of each input will be treated as object id/name.}

\item{.complete}{If \code{TRUE}, make sure the returned field number meets the
\verb{\\min-fields} requirement. Default: \code{TRUE}}

\item{.all}{If \code{TRUE}, make sure the all possible fields are returned.
Default: \code{FALSE}.}

\item{.scalar}{If \code{TRUE}, make sure the value of each field in the object is a
scalar value. If \code{FALSE}, \code{value_chr} and \code{value_num} column will be
list type. Default: \code{TRUE}.}

\item{.pair}{Only works when \code{.scalar} is \code{FALSE}. If \code{.pair} is \code{TRUE},
vector field values will be paired to each id/name on the LHS. In this
case, \code{value_chr} and \code{value_num} will be character type and double
type, respectively. When there is only one id/name on the LHS, it will
be replicated to match the length of the value vector. Default: \code{FALSE}.}

\item{.ref_assign}{If \code{TRUE}, allow using \verb{:=} to gather multiple
classes/objects on the LHS when defining the objects. Default: \code{TRUE}.}

\item{.unique}{If \code{TRUE}, make sure there are no duplicated classes/objects in
the input. Default: \code{FALSE}.}

\item{.empty}{If \code{TRUE}, allow using an empty list, i.e. \code{list()} to define an
object with all default values. Default: \code{TRUE}.}

\item{.default}{If \code{TRUE}, all empty fields will be filled with default
values if possible. Default: \code{TRUE}.}

\item{.env}{An environment specifying the environment to evaluate the \code{...}.
Default: \code{\link[=parent.frame]{parent.frame()}}.}
}
\value{
A named list of 2 element \code{object} and \code{value} which is a
\code{\link[data.table:data.table]{data.table::data.table()}} with object data and value data respectively.
}
\description{
Parse object field values given in list format
}
\keyword{internal}
