% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idd_object.R
\name{format.IddObject}
\alias{format.IddObject}
\title{Format an IddObject}
\usage{
\method{format}{IddObject}(x, comment = NULL, leading = 4L, sep_at = 29L, all = FALSE, ...)
}
\arguments{
\item{x}{An \link{IddObject} object.}

\item{comment}{A character vector to be used as comments of returned string
format object. If \code{NULL}, no comments are inserted. Default: \code{NULL}.}

\item{leading}{Leading spaces added to each field. Default: \code{4}.}

\item{sep_at}{The character width to separate value string and field string.
Default: \code{29} which is the same as IDF Editor.}

\item{all}{If \code{TRUE}, all fields in current class are returned, otherwise
only minimum fields are returned.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A single length character vector.
}
\description{
Format an \link{IddObject} into a string of an empty object of current class.
It is formatted exactly the same as in IDF Editor.
}
\examples{
\dontrun{
cat(format(use_idd(8.8, download = "auto")$Materal, leading = 0))
}

}
