% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSEIRD.R
\name{ModelSEIRD}
\alias{ModelSEIRD}
\alias{epiworld_seird}
\alias{plot.epiworld_seird}
\title{Susceptible-Exposed-Infected-Recovered-Deceased model (SEIRD)}
\usage{
ModelSEIRD(
  name,
  prevalence,
  transmission_rate,
  incubation_days,
  recovery_rate,
  death_rate
)

\method{plot}{epiworld_seird}(x, main = get_name(x), ...)
}
\arguments{
\item{name}{String. Name of the virus.}

\item{prevalence}{Double. Initial proportion of individuals with the virus.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Virus's rate of
infection.}

\item{incubation_days}{Numeric scalar greater than 0. Average number of
incubation days.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Rate of recovery_rate from virus.}

\item{death_rate}{Numeric scalar between 0 and 1. Rate of death from virus.}

\item{x}{Object of class SEIRD.}

\item{main}{Title of the plot}

\item{...}{Currently ignore.}
}
\value{
\itemize{
\item The \code{ModelSEIRD}function returns a model of class \link{epiworld_model}.
}

The \code{plot} function returns a plot of the SEIRD model of class
\link{epiworld_model}.
}
\description{
Susceptible-Exposed-Infected-Recovered-Deceased model (SEIRD)
}
\details{
The \link{initial_states} function allows the user to set the initial state of the
model. The user must provide a vector of proportions indicating the following
values: (1) Proportion of exposed agents who are infected, (2)
proportion of non-infected agents already removed, and (3) proportion of
non-ifected agents already deceased.
}
\examples{
model_seird <- ModelSEIRD(name = "COVID-19", prevalence = 0.01, 
transmission_rate = 0.9, recovery_rate = 0.1, incubation_days = 4, 
death_rate = 0.01)

# Adding a small world population
agents_smallworld(
  model_seird,
  n = 100000,
  k = 5,
  d = FALSE,
  p = .01
  )
  
# Running and printing
run(model_seird, ndays = 100, seed = 1912)
model_seird

plot(model_seird, main = "SEIRD Model")
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
