% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSEIR.R
\name{ModelSEIR}
\alias{ModelSEIR}
\alias{epiworld_seir}
\alias{plot.epiworld_seir}
\title{Susceptible Exposed Infected Recovered model (SEIR)}
\usage{
ModelSEIR(name, prevalence, infectiousness, incubation_days, recovery)

\method{plot}{epiworld_seir}(x, main = get_name(x), ...)
}
\arguments{
\item{name}{String. Name of the virus.}

\item{prevalence}{Double. Initial proportion of individuals with the virus.}

\item{infectiousness}{Numeric scalar between 0 and 1. Virus's rate of
infection.}

\item{incubation_days}{Numeric scalar greater than 0. Average number of
incubation days.}

\item{recovery}{Numeric scalar between 0 and 1. Rate of recovery from virus.}

\item{x}{Object of class SEIR.}

\item{main}{Title of the plot}

\item{...}{Currently ignore.}
}
\value{
\itemize{
\item The \code{ModelSEIR}function returns a model of class \link{epiworld_model}.
}

The \code{plot} function returns a plot of the SEIR model of class
\link{epiworld_model}.
}
\description{
Susceptible Exposed Infected Recovered model (SEIR)
}
\examples{
model_seir <- ModelSEIR(name = "COVID-19", prevalence = 0.01, 
infectiousness = 0.9, recovery = 0.1, incubation_days = 4)

# Adding a small world population
agents_smallworld(
  model_seir,
  n = 1000,
  k = 5,
  d = FALSE,
  p = .01
  )
  
# Running and printing
run(model_seir, ndays = 100, seed = 1912)
model_seir

plot(model_seir, main = "SEIR Model")
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
