% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_loop}
\alias{search_loop}
\title{Runs the search loop}
\usage{
search_loop(data_dir = NA)
}
\arguments{
\item{data_dir}{Path to the 'data directory' containing application settings, models and collected tweets.
If not provided the system will try to reuse the existing one from last session call of \code{\link{setup_config}} or use the EPI_HOME environment variable, Default: NA}
}
\value{
Nothing
}
\description{
Infinite loop ensuring the permanent collection of tweets
}
\details{
The detect loop is a pure R function designed for downloading tweets from the Twitter search API. It can handle several topics ensuring that all of them will be downloaded fairly using a 
round-robin philosophy and respecting Twitter API rate-limits.

The progress of this task is reported on the 'topics.json' file which is read or created by this function. This function will try to collect tweets respecting a 'collect_span' window
in minutes, which is defined on the Shiny app and defaults to 60 minutes.

To see more details about the collection algorithm please see epitweetr vignette.

In order to work, this task needs Twitter credentials, which can be set on the Shiny app or using \code{\link{set_twitter_app_auth}}
}
\examples{
if(FALSE){
   #Running the search loop
   library(epitweetr)
   message('Please choose the epitweetr data directory')
   search_loop(file.choose())
}
}
\seealso{
\code{\link{set_twitter_app_auth}}
}
