% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataviz.R
\name{create_map}
\alias{create_map}
\title{Plot the map report on the epitweetr dashboard}
\usage{
create_map(
  topic = c(),
  countries = c(1),
  date_min = "1900-01-01",
  date_max = "2100-01-01",
  with_retweets = FALSE,
  location_type = "tweet",
  caption = "",
  proj = NULL,
  forplotly = FALSE
)
}
\arguments{
\item{topic}{Character(1) containing the topic to use for the report}

\item{countries}{Character vector containing the name of the countries and regions to plot or their respective indexes on the Shiny app, default: c(1)}

\item{date_min}{Date indicating start of the reporting period, default: "1900-01-01"}

\item{date_max}{Date indicating end of the reporting period, default: "2100-01-01"}

\item{with_retweets}{Logical value indicating whether to include retweets in the time series, default: FALSE}

\item{location_type}{Character(1) vector indicating the location type. Possible values 'tweet', 'user' or 'both', default: 'tweet'}

\item{caption}{Character(1) vector indicating a caption to print at the bottom of the chart, default: ""}

\item{proj}{Parameter indicating the CRS (Corrdinate Reference System) to use on PROJ4 format \code{\link[sp]{CRS-class}}?
If null and all countries are selected +proj=robin is used (Robinson projection) otherwise the Lambert azimuthal equal-area projection will be chosen, default: NULL}

\item{forplotly}{Logical(1) parameter indicating whether some hacks are activated to improve plotly rendering, default: FALSE}
}
\value{
A named list containing two elements: 'chart' with the ggplot2 figure and 'data' containing the dataframe that was used to build the map.
}
\description{
Generates a bubble map plot of number of tweets by countries, for one topic
}
\details{
Produces a bubble chart map for a particular topic on number of tweets collected based on the provided parameters.
The map will display information at country level if more than one country is selected, otherwise it will display bubbles at the smallest possible location identified for each tweet within the period
which could be any administrative level or city level.

Tweets associated with a country but with no finer granularity are omitted when displaying a single country.

When an aggregated zone is requested, all countries in that zone are included.

This functions requires that \code{\link{search_loop}} and \code{\link{detect_loop}} have already been run successfully to show results.
}
\examples{
if(FALSE){
   #Getting bubble chart for dengue for South America for last 30 days
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   create_map(
     topic = "dengue", 
     countries = "South America", 
     date_min = as.Date(Sys.time())-30, 
     date_max=as.Date(Sys.time())
   ) 
}
}
\seealso{
\code{\link{trend_line}}
 \code{\link{create_topwords}}
 \code{\link{aggregate_tweets}}
 \code{\link{geotag_tweets}}
 \code{\link{detect_loop}}
 \code{\link{search_loop}}
 \code{\link[sp]{spTransform}},\code{\link[sp]{coordinates}},\code{\link[sp]{is.projected}},\code{\link[sp]{CRS-class}}
 \code{\link[ggplot2]{fortify}},\code{\link[ggplot2]{geom_polygon}},\code{\link[ggplot2]{geom_point}}
}
