% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_param.R
\name{extract_param}
\alias{extract_param}
\title{Calculate the parameters of a parametric probability distribution from
reported values of percentiles, or median and range}
\usage{
extract_param(
  type = c("percentiles", "range"),
  values,
  distribution = c("lnorm", "gamma", "weibull", "norm"),
  percentiles,
  samples,
  control = list(max_iter = 1000, tolerance = 1e-05)
)
}
\arguments{
\item{type}{A \code{character} defining whether summary statistics based
around \code{percentiles} (default) or \code{range}.}

\item{values}{A \code{vector}. If \code{type = percentiles}: \code{c(percentile_1, percentile_2)}; and if \code{type = range}: \code{c(median, min, max)}.}

\item{distribution}{A \code{character} specifying distribution to use.
Default is \code{lnorm}; also takes \code{gamma}, \code{weibull} and \code{norm}.}

\item{percentiles}{A \code{vector} with two elements specifying the
percentiles defined in \code{values} if using \code{type = "percentiles"}.
Percentiles should be specified between 0 and 1. For example 2.5th and 97.5th
percentile is given as \code{c(0.025, 0.975)}.}

\item{samples}{A \code{numeric} specifying the sample size if using
\code{type = "range"}.}

\item{control}{A named list containing options for the optimisation. List
element \verb{$max_iter} is a \code{numeric} specifying the maximum number of times
the parameter extraction will run optimisation before returning result early.
This prevents overly long optimisation loops if optimisation is unstable and
does not converge over multiple iterations. Default is 1000 iterations. List
element \verb{$tolerance} is passed to \code{\link[=.check_optim_conv]{.check_optim_conv()}} for tolerance on
parameter convergence over iterations of optimisation. Elements of in the
control list are not passed to \code{\link[=optim]{optim()}}.}
}
\value{
A named \code{numeric} vector with the parameter values of the
distribution. If the \code{distribution = lnorm} then the parameters returned are
the meanlog and sdlog; if the \code{distribution = gamma} or \code{distribution = weibull} then the parameters returned are the shape and scale; if
\code{distribution = norm} then the parameters returned are mean and sd.
}
\description{
Summary data of distributions, as provided by reports and meta-analyses, can
be used to extract the parameters of a chosen distribution. Currently
available distributions are: lognormal, gamma, Weibull and normal.
Extracting from a lognormal returns the meanlog and sdlog parameters,
extracting from the gamma and Weibull returns the shape and scale parameters,
and extracting from the normal returns the mean and sd parameters.
}
\details{
For \code{gamma}, \code{lnorm} and \code{weibull}, \code{extract_param()} works only
for strictly positive values at the percentiles of a distribution or the
median and range of data (numerics supplied to the \code{values} argument).
This means that negative values at the lower percentile or lower range
will not work with this function although they may present themselves in
epidemiological data (e.g. negative serial interval). For the \code{norm}
distribution negative values are allowed.
}
\examples{
# set seed to control for stochasticity
set.seed(1)

# extract parameters of a lognormal distribution from the 75 percentiles
extract_param(
  type = "percentiles",
  values = c(6, 13),
  distribution = "lnorm",
  percentiles = c(0.125, 0.875)
)

# extract parameters of a gamma distribution from median and range
extract_param(
  type = "range",
  values = c(10, 3, 18),
  distribution = "gamma",
  samples = 20
)
}
\author{
Adam Kucharski, Joshua W. Lambert
}
\keyword{extract}
