% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter-utils.R
\name{create_citation}
\alias{create_citation}
\title{Create a citation for an \verb{<epiparameter>} object}
\usage{
create_citation(
  author = utils::person(),
  year = NA_integer_,
  title = NA_character_,
  journal = NA_character_,
  doi = NA_character_,
  pmid = NA_integer_
)
}
\arguments{
\item{author}{Either a \verb{<person>}, a \code{character} string, or a vector or list
of \code{characters} in the case of multiple authors. Specify the full name
(\verb{"<given name>" "<family name>"}). When using \code{characters} make sure the
name can be converted to a \verb{<person>} (see \code{\link[=as.person]{as.person()}}). Use white space
separation between names. Multiple names can be stored within a single
\verb{<person>} (see \code{\link[=person]{person()}}).}

\item{year}{A \code{numeric} of the year of publication.}

\item{title}{A \code{character} string with the title of the article that
published the epidemiological parameters.}

\item{journal}{A \code{character} string with the name of the journal that
published the article that published the epidemiological parameters.
This can also be a pre-print server, e.g., medRxiv.}

\item{doi}{A \code{character} string of the Digital Object Identifier (DOI)
assigned to papers which are unique to each paper.}

\item{pmid}{A \code{character} string with the PubMed unique identifier number
(PMID) assigned to papers to give them a unique identifier within PubMed.}
}
\value{
A \verb{<bibentry>} object of the citation
}
\description{
A helper function when creating an \verb{<epiparameter>} object to
create a citation list with sensible defaults, type checking and arguments
to help remember which citation information is accepted in the list.
}
\details{
This function acts as a wrapper around \code{\link[=bibentry]{bibentry()}} to create
citations for sources reporting epidemiological parameters.
}
\examples{
create_citation(
  author = person(given = "John", family = "Smith"),
  year = 2002,
  title = "COVID-19 incubation period",
  journal = "Epi Journal",
  doi = "10.19832/j.1366-9516.2012.09147.x"
)
}
