% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getQTL}
\alias{getQTL}
\title{QTL retrieval.}
\usage{
getQTL(pop)
}
\arguments{
\item{pop}{An object of class \code{'Population'}.}
}
\value{
A \code{data.frame} containing the IDs and indices of all
QTLs is returned.
}
\description{
Retrieve the QTLs being used for this population.
}
\details{
\code{getQTL} retrieves the IDs and indices of the SNPs being used
as QTLs for a given \code{Population} object.
}
\examples{
# Create population
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0.6, traitVar = 40
)

# Get the SNP IDs of the QTLs
getQTL(pop)
}
\seealso{
\code{\link{Population}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
