% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obs_cor.R
\name{obs_cor}
\alias{obs_cor}
\title{Observational correlations between traits}
\usage{
obs_cor(trait, cor_coef_threshold = 0.8, mode = c("table", "raw"))
}
\arguments{
\item{trait}{name of the trait, e.g. "body mass index"}

\item{cor_coef_threshold}{correlation coefficient threshold}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \code{GET /obs-cor}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-obs-cor}{\code{GET /obs-cor}}
}
\examples{
obs_cor(trait = "Body mass index (BMI)") \%>\%
  dplyr::glimpse()

# Use a different threshold
obs_cor(trait = "Body mass index (BMI)", cor_coef_threshold = 0.8) \%>\%
  dplyr::glimpse()
}
