% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{posterior_metrics}
\alias{posterior_metrics}
\title{CRPS, Mean Absolute Error, Median Absolute Error}
\usage{
posterior_metrics(object, type, newdata = NULL, groups = NULL, metrics = NULL)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{type}{A string specifying the name of the observations to plot. This should match one
of the names of the response variables in the \code{obs} argument used int the call to \code{\link{epim}}.}

\item{newdata}{If provided, the original \code{data} used
in \code{object} is overridden. Useful for forecasting}

\item{groups}{Either \code{NULL} or a character vector specifying the groups
to plot for. Default is \code{NULL}, which plots all modeled groups.}

\item{metrics}{A string or character vector specifying the plotted
forecast error metrics. One of \code{NULL}, \code{"crps"},
\code{"mean_abs_error"}}
}
\value{
A dataframe giving forecast error for each metric and observation
}
\description{
Calculate daily error using one of three metrics, and also return coverage
of credible intervals. Uses continuous ranked probability
score (CRPS), mean absolute error and median absolute error.
}
