% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R, R/plots_epi.R
\name{posterior_sample_size.epimodel}
\alias{posterior_sample_size.epimodel}
\alias{all_obs_types.epimodel}
\alias{plot_linpred}
\alias{plot_linpred.epimodel}
\title{Plotting the posterior linear predictor for R or ascertainment rates}
\usage{
\method{posterior_sample_size}{epimodel}(object)

\method{all_obs_types}{epimodel}(object)

plot_linpred(object, ...)

\method{plot_linpred}{epimodel}(
  object,
  type = NULL,
  groups = NULL,
  dates = NULL,
  date_breaks = "2 weeks",
  date_format = "\%Y-\%m-\%d",
  levels = c(30, 60, 90),
  ...
)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{...}{Additional arguments for
\code{\link[epidemia]{posterior_predict.epimodel}}. Examples include
\code{newdata}, which allows
predictions or counterfactuals.}

\item{type}{the name of the observations to plot. This should match one
of the names of the \code{obs} argument to \code{epim}.}

\item{groups}{Either \code{NULL} or a character vector specifying the groups
to plot for. Default is \code{NULL}, which plots all modeled groups.}

\item{dates}{A length 2 vector of \code{Date} objects. This defines the
start and end dates of the date-range to be plotted. Must be coercible to
\code{Date} if not \code{NA}. If an element of the vector is \code{NA} then
the default lower/upper limit is used. See examples.}

\item{date_breaks}{A string giving the distance between date tick labels.
Default is \code{"2 weeks"}. This is passed as the \code{date_breaks} argument to
\code{\link[ggplot2]{scale_x_date}}. Please see \href{https://ggplot2.tidyverse.org/reference/scale_date.html}{here} for details.}

\item{date_format}{This function attempts to coerce the \code{dates} argument
to a vector of \code{Date} objects. \code{date_format} is passed as the \code{format}
argument to \code{\link[base]{as.Date}}. Default is "\%Y-\%m-\%d".}

\item{levels}{A numeric vector defining the levels of the plotted
credible intervals.}
}
\value{
A \code{ggplot} object which can be further modified.
}
\description{
Plots credible intervals for the observed data under the posterior
predictive distribution, and for a specific observation type.
The user can control the levels of the intervals and the plotted group(s).
This is a generic function.
}
