% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_nidss_dengue}
\alias{pub_nidss_dengue}
\title{NIDSS dengue data}
\usage{
pub_nidss_dengue(locations, epiweeks, fetch_args = fetch_args_list())
}
\arguments{
\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/nidss_dengue.html}

Obtains counts of confirmed dengue cases in Taiwan from Taiwan National
Infectious Disease Statistical System.
}
\details{
Possible location inputs can be found in
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/labels/nidss_regions.txt}
and
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/labels/nidss_locations.txt}.
}
\examples{
\dontrun{
pub_nidss_dengue(locations = "taipei", epiweeks = epirange(201201, 201301))
}
}
\keyword{endpoint}
