% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.r
\name{get_gender_wage_gap}
\alias{get_gender_wage_gap}
\title{Retreive the percent by which hourly wages of female workers are less than hourly wages of male workers}
\usage{
get_gender_wage_gap(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or \code{r} for a parition by race}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
The gender wage gap is the percent by which hourly wages of female workers are less than
hourly wages of male workers. It is also often expressed as a wage ratio (women's
share of men's wages) by subtracting the gap from 100 percent.
}
\details{
\itemize{
\item{A median gender wage gap of 17.3 percent means that a typical woman is paid 17.3
      percent less per hour than a typical man.}
\item{An average gender wage gap of 19.7 percent means that on average women are paid
      19.7 percent less per hour than men.}
\item{A regression-based gender wage gap of 21.7 percent means that on average women
      are paid 21.7 percent less per hour than men, all else held equal (controlling for
      gender, race and ethnicity, education, experience, and geographic location).}
}
}
\examples{
get_gender_wage_gap()

get_gender_wage_gap("r")
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}

